/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;

public interface ModelVisibilityDataCapable<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final String EASY_NPC_DATA_MODEL_VISIBLE_TAG = "Visible";
    public static final StreamCodec<RegistryFriendlyByteBuf, Map<ModelPartType, Boolean>> MODEL_PART_VISIBILITY_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Map<ModelPartType, Boolean>>(){

        public Map<ModelPartType, Boolean> decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            CompoundTag compoundTag = registryFriendlyByteBuf.readNbt();
            EnumMap<ModelPartType, Boolean> modelPartMap = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
            for (String key : compoundTag.getAllKeys()) {
                ModelPartType modelPartType = ModelPartType.get(key);
                if (modelPartType == null) continue;
                modelPartMap.put(modelPartType, compoundTag.getBoolean(key));
            }
            return modelPartMap;
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, Map<ModelPartType, Boolean> modelPartMap) {
            CompoundTag compoundTag = new CompoundTag();
            for (Map.Entry<ModelPartType, Boolean> entry : modelPartMap.entrySet()) {
                compoundTag.putBoolean(entry.getKey().getTagName(), entry.getValue().booleanValue());
            }
            registryFriendlyByteBuf.writeNbt((Tag)compoundTag);
        }
    };

    default public EnumMap<ModelPartType, Boolean> getModelPartVisibility() {
        EnumMap<ModelPartType, Boolean> modelPartMap = (EnumMap<ModelPartType, Boolean>)this.getSynchedEntityData(SynchedDataIndex.MODEL_VISIBILITY);
        if (modelPartMap == null) {
            modelPartMap = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
            this.setModelPartVisibility(modelPartMap);
        }
        return modelPartMap;
    }

    default public void setModelPartVisibility(EnumMap<ModelPartType, Boolean> modelPartMap) {
        if (modelPartMap != null) {
            this.setSynchedEntityData(SynchedDataIndex.MODEL_VISIBILITY, modelPartMap, true);
        }
    }

    default public void setModelPartVisibility(ModelPartType modelPartType, boolean visible) {
        EnumMap<ModelPartType, Boolean> modelPartMap = this.getModelPartVisibility();
        if (modelPartType != null) {
            modelPartMap.put(modelPartType, visible);
            this.setModelPartVisibility(new EnumMap<ModelPartType, Boolean>(modelPartMap));
        }
    }

    default public boolean getModelPartVisibility(EquipmentSlot equipmentSlot) {
        return switch (equipmentSlot) {
            case EquipmentSlot.HEAD -> this.getModelPartVisibility(ModelPartType.HELMET);
            case EquipmentSlot.CHEST -> this.getModelPartVisibility(ModelPartType.CHESTPLATE);
            case EquipmentSlot.LEGS -> this.getModelPartVisibility(ModelPartType.LEGGINGS);
            case EquipmentSlot.FEET -> this.getModelPartVisibility(ModelPartType.BOOTS);
            default -> false;
        };
    }

    default public boolean getModelPartVisibility(ModelPartType modelPartType) {
        EnumMap<ModelPartType, Boolean> modelPartMap = this.getModelPartVisibility();
        return modelPartMap.getOrDefault((Object)modelPartType, true);
    }

    default public void setModelPartVisibility(EquipmentSlot equipmentSlot, boolean visible) {
        switch (equipmentSlot) {
            case HEAD: {
                this.setModelPartVisibility(ModelPartType.HELMET, visible);
                break;
            }
            case CHEST: {
                this.setModelPartVisibility(ModelPartType.CHESTPLATE, visible);
                break;
            }
            case LEGS: {
                this.setModelPartVisibility(ModelPartType.LEGGINGS, visible);
                break;
            }
            case FEET: {
                this.setModelPartVisibility(ModelPartType.BOOTS, visible);
                break;
            }
        }
    }

    default public boolean hasChangedModelVisibility() {
        EnumMap<ModelPartType, Boolean> modelPartMap = this.getModelPartVisibility();
        for (Map.Entry<ModelPartType, Boolean> entry : modelPartMap.entrySet()) {
            if (entry.getValue() == null) continue;
            return true;
        }
        return false;
    }

    default public void defineSynchedModelVisibilityData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_VISIBILITY, new EnumMap(ModelPartType.class));
    }

    default public void addAdditionalModelVisibilityData(CompoundTag compoundTag) {
        CompoundTag visibilityTag = new CompoundTag();
        EnumMap<ModelPartType, Boolean> modelPartMap = this.getModelPartVisibility();
        for (Map.Entry<ModelPartType, Boolean> entry : modelPartMap.entrySet()) {
            visibilityTag.putBoolean(entry.getKey().getTagName(), entry.getValue().booleanValue());
        }
        compoundTag.put(EASY_NPC_DATA_MODEL_VISIBLE_TAG, (Tag)visibilityTag);
    }

    default public void readAdditionalModelVisibilityData(CompoundTag compoundTag) {
        if (!compoundTag.contains(EASY_NPC_DATA_MODEL_VISIBLE_TAG)) {
            return;
        }
        CompoundTag visibilityTag = compoundTag.getCompound(EASY_NPC_DATA_MODEL_VISIBLE_TAG);
        EnumMap<ModelPartType, Boolean> modelPartMap = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
        for (String key : visibilityTag.getAllKeys()) {
            ModelPartType modelPartType = ModelPartType.get(key);
            if (modelPartType == null) continue;
            modelPartMap.put(modelPartType, visibilityTag.getBoolean(key));
        }
        this.setModelPartVisibility(modelPartMap);
    }
}

