/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.PathfinderMob;

public interface ModelScaleDataCapable<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final CustomScale DEFAULT_MODEL_PART_SCALE = new CustomScale(1.0f, 1.0f, 1.0f);
    public static final CustomScale DEFAULT_MODEL_SCALE = new CustomScale(1.0f, 1.0f, 1.0f);
    public static final String EASY_NPC_DATA_MODEL_SCALE_TAG = "Scale";
    public static final StreamCodec<RegistryFriendlyByteBuf, Map<ModelPartType, CustomScale>> MODEL_PART_SCALE_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Map<ModelPartType, CustomScale>>(){

        public Map<ModelPartType, CustomScale> decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            CompoundTag compoundTag = registryFriendlyByteBuf.readNbt();
            EnumMap<ModelPartType, CustomScale> modelPartMap = new EnumMap<ModelPartType, CustomScale>(ModelPartType.class);
            for (String key : compoundTag.getAllKeys()) {
                ModelPartType modelPartType = ModelPartType.get(key);
                if (modelPartType == null) continue;
                modelPartMap.put(modelPartType, new CustomScale(modelPartType, compoundTag));
            }
            return modelPartMap;
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, Map<ModelPartType, CustomScale> modelPartMap) {
            CompoundTag compoundTag = new CompoundTag();
            for (Map.Entry<ModelPartType, CustomScale> entry : modelPartMap.entrySet()) {
                compoundTag.put(entry.getKey().getTagName(), (Tag)entry.getValue().save());
            }
            registryFriendlyByteBuf.writeNbt((Tag)compoundTag);
        }
    };

    default public EnumMap<ModelPartType, CustomScale> getModelPartScale() {
        EnumMap<ModelPartType, CustomScale> modelPartMap = (EnumMap<ModelPartType, CustomScale>)this.getSynchedEntityData(SynchedDataIndex.MODEL_SCALE);
        if (modelPartMap == null) {
            modelPartMap = new EnumMap<ModelPartType, CustomScale>(ModelPartType.class);
            this.setModelPartScale(modelPartMap);
        }
        return modelPartMap;
    }

    default public void setModelPartScale(EnumMap<ModelPartType, CustomScale> modelPartMap) {
        if (modelPartMap != null) {
            this.setSynchedEntityData(SynchedDataIndex.MODEL_SCALE, modelPartMap, true);
        }
    }

    default public void setModelPartScale(ModelPartType modelPartType, CustomScale Scale) {
        EnumMap<ModelPartType, CustomScale> modelPartMap = this.getModelPartScale();
        if (modelPartType != null) {
            modelPartMap.put(modelPartType, Scale);
            this.setModelPartScale(new EnumMap<ModelPartType, CustomScale>(modelPartMap));
            if (modelPartType == ModelPartType.ROOT) {
                this.getEntity().refreshDimensions();
            }
        }
    }

    default public CustomScale getModelPartScale(ModelPartType modelPartType) {
        EnumMap<ModelPartType, CustomScale> modelPartMap = this.getModelPartScale();
        return modelPartMap.getOrDefault((Object)modelPartType, DEFAULT_MODEL_PART_SCALE);
    }

    default public boolean hasChangedModelScale() {
        EnumMap<ModelPartType, CustomScale> modelPartMap = this.getModelPartScale();
        for (Map.Entry<ModelPartType, CustomScale> entry : modelPartMap.entrySet()) {
            if (!entry.getValue().hasChanged()) continue;
            return true;
        }
        return false;
    }

    default public CustomScale getDefaultModelScale() {
        return DEFAULT_MODEL_SCALE;
    }

    default public void defineSynchedModelScaleData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_SCALE, new EnumMap(ModelPartType.class));
    }

    default public void addAdditionalModelScaleData(CompoundTag compoundTag) {
        CompoundTag positionsTag = new CompoundTag();
        EnumMap<ModelPartType, CustomScale> modelPartMap = this.getModelPartScale();
        for (Map.Entry<ModelPartType, CustomScale> entry : modelPartMap.entrySet()) {
            positionsTag.put(entry.getKey().getTagName(), (Tag)entry.getValue().save());
        }
        compoundTag.put(EASY_NPC_DATA_MODEL_SCALE_TAG, (Tag)positionsTag);
    }

    default public void readAdditionalModelScaleData(CompoundTag compoundTag) {
        if (!compoundTag.contains(EASY_NPC_DATA_MODEL_SCALE_TAG)) {
            return;
        }
        CompoundTag positionTag = compoundTag.getCompound(EASY_NPC_DATA_MODEL_SCALE_TAG);
        EnumMap<ModelPartType, CustomScale> modelPartMap = new EnumMap<ModelPartType, CustomScale>(ModelPartType.class);
        for (String key : positionTag.getAllKeys()) {
            ModelPartType modelPartType = ModelPartType.get(key);
            if (modelPartType == null) continue;
            modelPartMap.put(modelPartType, new CustomScale(modelPartType, positionTag));
        }
        this.setModelPartScale(modelPartMap);
    }
}

