/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.display.DisplayAttributeDataSet;
import de.markusbordihn.easynpc.data.display.DisplayAttributeEntry;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.type.ValueType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.PathfinderMob;

public interface DisplayAttributeDataCapable<E extends PathfinderMob>
extends EasyNPC<E> {
    public static final String DATA_DISPLAY_ATTRIBUTE_TAG = "DisplayAttribute";
    public static final StreamCodec<RegistryFriendlyByteBuf, EnumMap<DisplayAttributeType, DisplayAttributeEntry>> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, EnumMap<DisplayAttributeType, DisplayAttributeEntry>>(){

        public EnumMap<DisplayAttributeType, DisplayAttributeEntry> decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            CompoundTag compoundTag = registryFriendlyByteBuf.readNbt();
            EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(DisplayAttributeType.class);
            for (String key : compoundTag.getAllKeys()) {
                DisplayAttributeType displayAttributeType = DisplayAttributeType.get(key);
                if (displayAttributeType == null) continue;
                displayAttributeMap.put(displayAttributeType, new DisplayAttributeEntry(compoundTag.getCompound(key)));
            }
            return displayAttributeMap;
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap) {
            CompoundTag compoundTag = new CompoundTag();
            for (Map.Entry<DisplayAttributeType, DisplayAttributeEntry> entry : displayAttributeMap.entrySet()) {
                CompoundTag entryTag = new CompoundTag();
                entry.getValue().write(entryTag);
                compoundTag.put(entry.getKey().name(), (Tag)entryTag);
            }
            registryFriendlyByteBuf.writeNbt((Tag)compoundTag);
        }
    };

    default public DisplayAttributeDataSet getDisplayAttributeData() {
        DisplayAttributeDataSet displayAttributeDataSet = (DisplayAttributeDataSet)this.getSynchedEntityData(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET);
        if (displayAttributeDataSet == null) {
            displayAttributeDataSet = DisplayAttributeDataSet.createDefault();
            this.setDisplayAttributeData(displayAttributeDataSet);
        }
        return displayAttributeDataSet;
    }

    default public void setDisplayAttributeData(DisplayAttributeDataSet displayAttributeDataSet) {
        if (displayAttributeDataSet != null) {
            this.setSynchedEntityData(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, displayAttributeDataSet, true);
            this.syncDisplayAttributesToEntity(displayAttributeDataSet);
        }
    }

    default public void syncDisplayAttributesToEntity(DisplayAttributeDataSet displayAttributeDataSet) {
        DisplayAttributeEntry nameVisibilityEntry;
        if (displayAttributeDataSet.hasAttribute(DisplayAttributeType.NAME_VISIBILITY) && (nameVisibilityEntry = displayAttributeDataSet.getAttribute(DisplayAttributeType.NAME_VISIBILITY)) != null) {
            try {
                NameVisibilityType nameVisibilityType = NameVisibilityType.valueOf(nameVisibilityEntry.stringValue());
                this.getEntity().setCustomNameVisible(nameVisibilityType != NameVisibilityType.NEVER);
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid name visibility type: {}", (Object)nameVisibilityEntry.stringValue());
            }
        }
    }

    default public void clearDisplayAttributeData() {
        this.setDisplayAttributeData(DisplayAttributeDataSet.createDefault());
    }

    default public boolean hasDisplayAttribute(DisplayAttributeType displayAttributeType) {
        return this.getDisplayAttributeData().hasAttribute(displayAttributeType);
    }

    default public boolean getDisplayBooleanAttribute(DisplayAttributeType displayAttributeType) {
        DisplayAttributeEntry entry = this.getDisplayAttributeData().getAttribute(displayAttributeType);
        return entry != null && entry.booleanValue();
    }

    default public int getDisplayIntAttribute(DisplayAttributeType displayAttributeType) {
        DisplayAttributeEntry entry = this.getDisplayAttributeData().getAttribute(displayAttributeType);
        return entry != null ? entry.intValue() : 0;
    }

    default public String getDisplayStringAttribute(DisplayAttributeType displayAttributeType) {
        DisplayAttributeEntry entry = this.getDisplayAttributeData().getAttribute(displayAttributeType);
        return entry != null ? entry.stringValue() : "";
    }

    default public <T extends Enum<T>> T getDisplayEnumAttribute(DisplayAttributeType displayAttributeType, Class<T> enumClass) {
        String enumValue = this.getDisplayStringAttribute(displayAttributeType);
        try {
            return Enum.valueOf(enumClass, enumValue);
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to get enum value {} for class {}: {}", (Object)enumValue, enumClass, (Object)e);
            return null;
        }
    }

    default public <T> void setDisplayAttribute(DisplayAttributeType displayAttributeType, ValueType valueType, T value) {
        DisplayAttributeEntry newEntry;
        switch (valueType) {
            case BOOLEAN: {
                DisplayAttributeEntry displayAttributeEntry = new DisplayAttributeEntry((Boolean)value);
                break;
            }
            case INTEGER: {
                DisplayAttributeEntry displayAttributeEntry = new DisplayAttributeEntry((Integer)value);
                break;
            }
            case STRING: {
                DisplayAttributeEntry displayAttributeEntry = new DisplayAttributeEntry((String)value);
                break;
            }
            default: {
                log.error("Invalid display value type {} for {}", (Object)valueType, (Object)displayAttributeType);
                DisplayAttributeEntry displayAttributeEntry = newEntry = null;
            }
        }
        if (newEntry != null) {
            this.setDisplayAttributeData(this.getDisplayAttributeData().withAttribute(displayAttributeType, newEntry));
        }
    }

    default public void setDisplayAttribute(DisplayAttributeType displayAttributeType, Enum<?> enumValue) {
        this.setDisplayAttribute(displayAttributeType, ValueType.STRING, enumValue.toString());
    }

    default public void defineSynchedDisplayAttributeData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, DisplayAttributeDataSet.createDefault());
    }

    default public void readAdditionalDisplayAttributeData(CompoundTag compoundTag) {
        if (!compoundTag.contains(DATA_DISPLAY_ATTRIBUTE_TAG)) {
            return;
        }
        DisplayAttributeDataSet displayAttributeData = new DisplayAttributeDataSet(compoundTag.getList(DATA_DISPLAY_ATTRIBUTE_TAG, 10));
        this.setDisplayAttributeData(displayAttributeData);
    }

    default public void addAdditionalDisplayAttributeData(CompoundTag compoundTag) {
        DisplayAttributeDataSet displayAttributeData = this.getDisplayAttributeData();
        if (displayAttributeData != null) {
            compoundTag.put(DATA_DISPLAY_ATTRIBUTE_TAG, (Tag)displayAttributeData.save());
        }
    }
}

