/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;

public interface AttackDataCapable<E extends PathfinderMob>
extends EasyNPC<E>,
NeutralMob,
RangedAttackMob,
CrossbowAttackMob {
    public int getAttackAnimationTick();

    default public boolean isChargingCrossbow() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.ATTACK_IS_CHARGING_CROSSBOW);
    }

    default public void setChargingCrossbow(boolean isCharging) {
        this.setSynchedEntityData(SynchedDataIndex.ATTACK_IS_CHARGING_CROSSBOW, isCharging);
    }

    default public void performRangedAttack(LivingEntity livingEntity, float damage) {
        AttackHandler.performDefaultRangedAttack(this.getLivingEntity(), livingEntity, damage);
    }

    default public void defineSynchedAttackData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.ATTACK_IS_CHARGING_CROSSBOW, false);
    }

    default public void addAdditionalAttackData(CompoundTag compoundTag) {
    }

    default public void readAdditionalAttackData(CompoundTag compoundTag) {
    }
}

