/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.model;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum ModelType {
    ALLAY(EnumSet.of(ModelPartType.HEAD, new ModelPartType[]{ModelPartType.BODY, ModelPartType.RIGHT_ARM, ModelPartType.LEFT_ARM, ModelPartType.RIGHT_WING, ModelPartType.LEFT_WING})),
    AVIAN(EnumSet.of(ModelPartType.HEAD, new ModelPartType[]{ModelPartType.BODY, ModelPartType.RIGHT_WING, ModelPartType.LEFT_WING, ModelPartType.RIGHT_LEG, ModelPartType.LEFT_LEG})),
    CANINE(EnumSet.of(ModelPartType.HEAD, new ModelPartType[]{ModelPartType.BODY, ModelPartType.RIGHT_FRONT_LEG, ModelPartType.LEFT_FRONT_LEG, ModelPartType.RIGHT_HIND_LEG, ModelPartType.LEFT_HIND_LEG, ModelPartType.TAIL})),
    CREEPER(EnumSet.of(ModelPartType.HEAD, new ModelPartType[]{ModelPartType.BODY, ModelPartType.RIGHT_FRONT_LEG, ModelPartType.LEFT_FRONT_LEG, ModelPartType.RIGHT_HIND_LEG, ModelPartType.LEFT_HIND_LEG})),
    EQUINE(EnumSet.of(ModelPartType.HEAD, new ModelPartType[]{ModelPartType.BODY, ModelPartType.RIGHT_FRONT_LEG, ModelPartType.LEFT_FRONT_LEG, ModelPartType.RIGHT_HIND_LEG, ModelPartType.LEFT_HIND_LEG, ModelPartType.TAIL})),
    FELINE(EnumSet.of(ModelPartType.HEAD, new ModelPartType[]{ModelPartType.BODY, ModelPartType.RIGHT_FRONT_LEG, ModelPartType.LEFT_FRONT_LEG, ModelPartType.RIGHT_HIND_LEG, ModelPartType.LEFT_HIND_LEG, ModelPartType.TAIL1, ModelPartType.TAIL2})),
    GOLEM(EnumSet.of(ModelPartType.HEAD, new ModelPartType[]{ModelPartType.BODY, ModelPartType.RIGHT_ARM, ModelPartType.LEFT_ARM, ModelPartType.RIGHT_LEG, ModelPartType.LEFT_LEG}), true),
    HUMANOID(EnumSet.of(ModelPartType.HEAD, new ModelPartType[]{ModelPartType.BODY, ModelPartType.RIGHT_ARM, ModelPartType.LEFT_ARM, ModelPartType.RIGHT_LEG, ModelPartType.LEFT_LEG}), true),
    ILLAGER(EnumSet.of(ModelPartType.HEAD, new ModelPartType[]{ModelPartType.BODY, ModelPartType.ARMS, ModelPartType.RIGHT_ARM, ModelPartType.LEFT_ARM, ModelPartType.RIGHT_LEG, ModelPartType.LEFT_LEG}), true),
    PIXIE(EnumSet.of(ModelPartType.HEAD, new ModelPartType[]{ModelPartType.BODY, ModelPartType.RIGHT_ARM, ModelPartType.LEFT_ARM, ModelPartType.RIGHT_WING, ModelPartType.LEFT_WING})),
    QUADRUPED(EnumSet.of(ModelPartType.HEAD, new ModelPartType[]{ModelPartType.BODY, ModelPartType.RIGHT_FRONT_LEG, ModelPartType.LEFT_FRONT_LEG, ModelPartType.RIGHT_HIND_LEG, ModelPartType.LEFT_HIND_LEG})),
    SPIDER(EnumSet.of(ModelPartType.HEAD, ModelPartType.RIGHT_ARM, ModelPartType.LEFT_ARM)),
    VILLAGER(EnumSet.of(ModelPartType.HEAD, ModelPartType.BODY, ModelPartType.ARMS, ModelPartType.RIGHT_LEG, ModelPartType.LEFT_LEG)),
    ZOMBIE(EnumSet.of(ModelPartType.HEAD, new ModelPartType[]{ModelPartType.BODY, ModelPartType.RIGHT_ARM, ModelPartType.LEFT_ARM, ModelPartType.RIGHT_LEG, ModelPartType.LEFT_LEG}), true);

    private static final int PRIMARY_LIMIT = 6;
    private final Set<ModelPartType> modelParts;
    private final boolean requiresHatSync;

    private ModelType(Set<ModelPartType> modelParts) {
        this(modelParts, false);
    }

    private ModelType(Set<ModelPartType> modelParts, boolean requiresHatSync) {
        this.modelParts = modelParts;
        this.requiresHatSync = requiresHatSync;
    }

    public Set<ModelPartType> getModelParts() {
        return this.modelParts;
    }

    public Set<ModelPartType> getPrimaryModelParts() {
        if (this.modelParts.size() > 6) {
            return this.modelParts.stream().limit(6L).collect(Collectors.toCollection(() -> EnumSet.noneOf(ModelPartType.class)));
        }
        return this.modelParts;
    }

    public boolean requiresHatSync() {
        return this.requiresHatSync;
    }
}

