/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.model;

import java.util.Locale;

public enum ModelPartType {
    ROOT("Root"),
    HEAD("Head"),
    HAT("Hat"),
    HELMET("Helmet"),
    BODY("Body"),
    CHESTPLATE("Chestplate"),
    BODY_JACKET("BodyJacket"),
    RIGHT_ARM("RightArm"),
    LEFT_ARM("LeftArm"),
    ARMS("Arms"),
    RIGHT_SLEEVE("RightSleeve"),
    LEFT_SLEEVE("LeftSleeve"),
    RIGHT_WING("RightWing"),
    LEFT_WING("LeftWing"),
    RIGHT_LEG("RightLeg"),
    LEFT_LEG("LeftLeg"),
    LEGGINGS("Leggings"),
    BOOTS("Boots"),
    RIGHT_PANTS("RightPants"),
    LEFT_PANTS("LeftPants"),
    RIGHT_FRONT_LEG("RightFrontLeg"),
    LEFT_FRONT_LEG("LeftFrontLeg"),
    RIGHT_HIND_LEG("RightHindLeg"),
    LEFT_HIND_LEG("LeftHindLeg"),
    TAIL("Tail"),
    TAIL1("Tail1"),
    TAIL2("Tail2"),
    UNKNOWN("Unknown");

    public final String tagName;

    private ModelPartType(String tagName) {
        this.tagName = tagName;
    }

    public static ModelPartType get(String modelPart) {
        if (modelPart == null || modelPart.isEmpty()) {
            return UNKNOWN;
        }
        try {
            return ModelPartType.valueOf(modelPart.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            for (ModelPartType modelPartTypeEnum : ModelPartType.values()) {
                if (!modelPartTypeEnum.tagName.equalsIgnoreCase(modelPart)) continue;
                return modelPartTypeEnum;
            }
            return UNKNOWN;
        }
    }

    public String getTagName() {
        return this.tagName;
    }
}

