/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.model;

import de.markusbordihn.easynpc.data.model.ModelAnimationBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record ModelAnimationData(ModelAnimationBehavior behavior) {
    public static final String DATA_BEHAVIOR_TAG = "Behavior";
    public static final ModelAnimationData DEFAULT = new ModelAnimationData(ModelAnimationBehavior.SMART);
    public static final StreamCodec<RegistryFriendlyByteBuf, ModelAnimationData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ModelAnimationData>(){

        public ModelAnimationData decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            return ModelAnimationData.decode((FriendlyByteBuf)registryFriendlyByteBuf);
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, ModelAnimationData modelAnimationData) {
            modelAnimationData.encode((FriendlyByteBuf)registryFriendlyByteBuf);
        }
    };

    public ModelAnimationData() {
        this(ModelAnimationBehavior.SMART);
    }

    public ModelAnimationData(CompoundTag compoundTag) {
        this(compoundTag.contains(DATA_BEHAVIOR_TAG) ? ModelAnimationBehavior.get(compoundTag.getString(DATA_BEHAVIOR_TAG)) : ModelAnimationBehavior.SMART);
    }

    public static ModelAnimationData decode(FriendlyByteBuf buffer) {
        return new ModelAnimationData((ModelAnimationBehavior)buffer.readEnum(ModelAnimationBehavior.class));
    }

    public boolean hasChanged() {
        return this.behavior != ModelAnimationBehavior.SMART;
    }

    public CompoundTag save() {
        CompoundTag compoundTag = new CompoundTag();
        if (this.behavior != null) {
            compoundTag.putString(DATA_BEHAVIOR_TAG, this.behavior.name());
        }
        return compoundTag;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.behavior);
    }
}

