/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.execution;

public enum ExecutionInterval {
    PER_MINUTE(60000L),
    PER_HOUR(3600000L),
    PER_DAY(86400000L),
    PER_WEEK(604800000L),
    PER_MONTH(2592000000L),
    LIFETIME(Long.MAX_VALUE);

    private final long milliseconds;

    private ExecutionInterval(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public static ExecutionInterval get(String name) {
        if (name == null || name.isEmpty()) {
            return PER_DAY;
        }
        try {
            return ExecutionInterval.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return PER_DAY;
        }
    }

    public boolean hasIntervalPassed(long lastExecution) {
        if (this == LIFETIME) {
            return false;
        }
        return System.currentTimeMillis() - lastExecution >= this.milliseconds;
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }
}

