/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.display;

import de.markusbordihn.easynpc.data.display.DisplayAttributeEntry;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record DisplayAttributeDataSet(EnumMap<DisplayAttributeType, DisplayAttributeEntry> attributes) {
    public static final StreamCodec<RegistryFriendlyByteBuf, DisplayAttributeDataSet> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, DisplayAttributeDataSet>(){

        public DisplayAttributeDataSet decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            return DisplayAttributeDataSet.decode(registryFriendlyByteBuf);
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, DisplayAttributeDataSet displayAttributeDataSet) {
            displayAttributeDataSet.encode(registryFriendlyByteBuf);
        }
    };
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public DisplayAttributeDataSet() {
        this(DisplayAttributeDataSet.createDefaultAttributes());
    }

    public DisplayAttributeDataSet(ListTag listTag) {
        this(DisplayAttributeDataSet.readAttributesFromList(listTag));
    }

    public static DisplayAttributeDataSet createDefault() {
        return new DisplayAttributeDataSet();
    }

    private static EnumMap<DisplayAttributeType, DisplayAttributeEntry> createDefaultAttributes() {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> map = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(DisplayAttributeType.class);
        map.put(DisplayAttributeType.LIGHT_LEVEL, new DisplayAttributeEntry(7));
        map.put(DisplayAttributeType.VISIBLE, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_AT_DAY, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_AT_NIGHT, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_IN_CREATIVE, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_IN_SPECTATOR, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_IN_STANDARD, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_TO_OWNER, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_TO_TEAM, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.NAME_VISIBILITY, new DisplayAttributeEntry(NameVisibilityType.ALWAYS.toString()));
        return map;
    }

    private static EnumMap<DisplayAttributeType, DisplayAttributeEntry> readAttributesFromList(ListTag listTag) {
        if (listTag == null || listTag.isEmpty()) {
            log.warn("Received null or empty ListTag for DisplayAttributeDataSet, using defaults");
            return DisplayAttributeDataSet.createDefaultAttributes();
        }
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> map = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(DisplayAttributeType.class);
        for (Tag entry : listTag) {
            CompoundTag entryCompoundTag;
            if (!(entry instanceof CompoundTag) || !(entryCompoundTag = (CompoundTag)entry).contains("Type")) {
                log.warn("Invalid entry in DisplayAttributeDataSet ListTag: {}", (Object)entry);
                continue;
            }
            DisplayAttributeType displayAttributeType = DisplayAttributeType.get(entryCompoundTag.getString("Type"));
            if (displayAttributeType == DisplayAttributeType.NONE) continue;
            map.put(displayAttributeType, new DisplayAttributeEntry(entryCompoundTag));
        }
        return map;
    }

    public static DisplayAttributeDataSet decode(RegistryFriendlyByteBuf buffer) {
        int size = buffer.readVarInt();
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> map = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(DisplayAttributeType.class);
        for (int i = 0; i < size; ++i) {
            DisplayAttributeType type = (DisplayAttributeType)buffer.readEnum(DisplayAttributeType.class);
            boolean boolValue = buffer.readBoolean();
            int intValue = buffer.readVarInt();
            String stringValue = buffer.readUtf();
            if (type == DisplayAttributeType.NONE) continue;
            map.put(type, new DisplayAttributeEntry(boolValue, intValue, stringValue));
        }
        return new DisplayAttributeDataSet(map);
    }

    public boolean hasAttribute(DisplayAttributeType attributeType) {
        return this.attributes.containsKey((Object)attributeType);
    }

    public DisplayAttributeEntry getAttribute(DisplayAttributeType attributeType) {
        return this.attributes.get((Object)attributeType);
    }

    public DisplayAttributeDataSet withAttribute(DisplayAttributeType attributeType, DisplayAttributeEntry entry) {
        if (attributeType == null || entry == null) {
            return this;
        }
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> newAttributes = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(this.attributes);
        newAttributes.put(attributeType, entry);
        return new DisplayAttributeDataSet(newAttributes);
    }

    public ListTag save() {
        ListTag listTag = new ListTag();
        if (this.attributes == null || this.attributes.isEmpty()) {
            return listTag;
        }
        for (Map.Entry<DisplayAttributeType, DisplayAttributeEntry> entry : this.attributes.entrySet()) {
            if (entry.getKey() == DisplayAttributeType.NONE) continue;
            CompoundTag entryTag = new CompoundTag();
            entryTag.putString("Type", entry.getKey().name());
            entry.getValue().write(entryTag);
            listTag.add((Object)entryTag);
        }
        return listTag;
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeVarInt(this.attributes.size());
        for (Map.Entry<DisplayAttributeType, DisplayAttributeEntry> entry : this.attributes.entrySet()) {
            if (entry.getKey() == DisplayAttributeType.NONE) continue;
            buffer.writeEnum((Enum)entry.getKey());
            buffer.writeBoolean(entry.getValue().booleanValue());
            buffer.writeVarInt(entry.getValue().intValue());
            buffer.writeUtf(entry.getValue().stringValue());
        }
    }
}

