/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.dialog;

public final class DialogPriority {
    public static final int MANUAL_ONLY = -1;
    public static final int FALLBACK = 0;
    public static final int LOW = 1;
    public static final int NORMAL = 5;
    public static final int HIGH = 10;
    public static final int CRITICAL = 100;

    private DialogPriority() {
    }

    public static int calculateDefaultPriority(String label) {
        if (label == null || label.isEmpty()) {
            return 0;
        }
        return switch (label.toLowerCase().trim()) {
            case "default", "start", "welcome", "greeting", "intro", "introduction" -> 10;
            case "main", "question", "help", "info", "information", "talk", "conversation" -> 5;
            case "bye", "goodbye", "farewell", "exit", "leave", "thanks", "thankyou", "idle", "random" -> 1;
            default -> 0;
        };
    }

    public static String getNameForPriority(int priority) {
        return switch (priority) {
            case -1 -> "Manual Only";
            case 0 -> "Fallback";
            case 1 -> "Low";
            case 5 -> "Normal";
            case 10 -> "High";
            case 100 -> "Critical";
            default -> "Custom";
        };
    }

    public static String getDisplayName(int priority) {
        return DialogPriority.getNameForPriority(priority) + " (" + priority + ")";
    }
}

