/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.attribute;

import de.markusbordihn.easynpc.data.attribute.BaseAttributeType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class BaseAttributes {
    public static final String ATTACK_DAMAGE_TAG = BaseAttributeType.ATTACK_DAMAGE.getTagName();
    public static final String ATTACK_KNOCKBACK_TAG = BaseAttributeType.ATTACK_KNOCKBACK.getTagName();
    public static final String BASE_ATTRIBUTES_TAG = "BaseAttributes";
    public static final String FOLLOW_RANGE_TAG = BaseAttributeType.FOLLOW_RANGE.getTagName();
    public static final String KNOCKBACK_RESISTANCE_TAG = BaseAttributeType.KNOCKBACK_RESISTANCE.getTagName();
    private double attackDamage = 2.0;
    private double attackKnockback = 0.0;
    private double followRange = 32.0;
    private double knockbackResistance = 0.0;

    public BaseAttributes() {
    }

    public BaseAttributes(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public BaseAttributes(LivingEntity livingEntity) {
        if (livingEntity == null) {
            return;
        }
        if (livingEntity.getAttribute(Attributes.FOLLOW_RANGE) != null) {
            this.setFollowRange(livingEntity.getAttribute(Attributes.FOLLOW_RANGE).getBaseValue());
        }
        if (livingEntity.getAttribute(Attributes.KNOCKBACK_RESISTANCE) != null) {
            this.setKnockbackResistance(livingEntity.getAttribute(Attributes.KNOCKBACK_RESISTANCE).getBaseValue());
        }
        if (livingEntity.getAttribute(Attributes.ATTACK_DAMAGE) != null) {
            this.setAttackDamage(livingEntity.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue());
        }
        if (livingEntity.getAttribute(Attributes.ATTACK_KNOCKBACK) != null) {
            this.setAttackKnockback(livingEntity.getAttribute(Attributes.ATTACK_KNOCKBACK).getBaseValue());
        }
    }

    public void load(CompoundTag compoundTag) {
        if (!compoundTag.contains(BASE_ATTRIBUTES_TAG)) {
            return;
        }
        CompoundTag baseAttributesTag = compoundTag.getCompound(BASE_ATTRIBUTES_TAG);
        if (baseAttributesTag.contains(FOLLOW_RANGE_TAG)) {
            this.setFollowRange(baseAttributesTag.getDouble(FOLLOW_RANGE_TAG));
        }
        if (baseAttributesTag.contains(KNOCKBACK_RESISTANCE_TAG)) {
            this.setKnockbackResistance(baseAttributesTag.getDouble(KNOCKBACK_RESISTANCE_TAG));
        }
        if (baseAttributesTag.contains(ATTACK_DAMAGE_TAG)) {
            this.setAttackDamage(baseAttributesTag.getDouble(ATTACK_DAMAGE_TAG));
        }
        if (baseAttributesTag.contains(ATTACK_KNOCKBACK_TAG)) {
            this.setAttackKnockback(baseAttributesTag.getDouble(ATTACK_KNOCKBACK_TAG));
        }
    }

    public CompoundTag save(CompoundTag compoundTag) {
        CompoundTag baseAttributesTag = new CompoundTag();
        baseAttributesTag.putDouble(FOLLOW_RANGE_TAG, (double)((float)this.getFollowRange()));
        baseAttributesTag.putDouble(KNOCKBACK_RESISTANCE_TAG, (double)((float)this.getKnockbackResistance()));
        baseAttributesTag.putDouble(ATTACK_DAMAGE_TAG, (double)((float)this.getAttackDamage()));
        baseAttributesTag.putDouble(ATTACK_KNOCKBACK_TAG, (double)((float)this.getAttackKnockback()));
        compoundTag.put(BASE_ATTRIBUTES_TAG, (Tag)baseAttributesTag);
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.save(new CompoundTag());
    }

    public double getFollowRange() {
        return this.followRange;
    }

    public void setFollowRange(double followRange) {
        this.followRange = followRange;
    }

    public double getKnockbackResistance() {
        return this.knockbackResistance;
    }

    public void setKnockbackResistance(double knockbackResistance) {
        this.knockbackResistance = knockbackResistance;
    }

    public double getAttackDamage() {
        return this.attackDamage;
    }

    public void setAttackDamage(double attackDamage) {
        this.attackDamage = attackDamage;
    }

    public double getAttackKnockback() {
        return this.attackKnockback;
    }

    public void setAttackKnockback(double attackKnockback) {
        this.attackKnockback = attackKnockback;
    }
}

