/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.config;

import de.markusbordihn.easynpc.config.Config;
import java.io.File;
import java.util.Properties;

public class SpawnerTypeConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "spawner_type.cfg";
    public static final String CONFIG_FILE_HEADER = "Spawner Type Configuration\n\n\n";
    public static short BOSS_SPAWNER_DELAY = (short)600;
    public static short BOSS_SPAWNER_MIN_SPAWN_DELAY = (short)6000;
    public static short BOSS_SPAWNER_MAX_SPAWN_DELAY = (short)18000;
    public static short BOSS_SPAWNER_SPAWN_COUNT = 1;
    public static short BOSS_SPAWNER_MAX_NEARBY_ENTITIES = 1;
    public static short BOSS_SPAWNER_REQUIRED_PLAYER_RANGE = (short)32;
    public static short BOSS_SPAWNER_SPAWN_RANGE = (short)16;
    public static short DEFAULT_SPAWNER_DELAY = (short)600;
    public static short DEFAULT_SPAWNER_MIN_SPAWN_DELAY = (short)400;
    public static short DEFAULT_SPAWNER_MAX_SPAWN_DELAY = (short)1200;
    public static short DEFAULT_SPAWNER_SPAWN_COUNT = (short)2;
    public static short DEFAULT_SPAWNER_MAX_NEARBY_ENTITIES = (short)4;
    public static short DEFAULT_SPAWNER_REQUIRED_PLAYER_RANGE = (short)16;
    public static short DEFAULT_SPAWNER_SPAWN_RANGE = (short)8;
    public static short GROUP_SPAWNER_DELAY = (short)600;
    public static short GROUP_SPAWNER_MIN_SPAWN_DELAY = (short)3000;
    public static short GROUP_SPAWNER_MAX_SPAWN_DELAY = (short)12000;
    public static short GROUP_SPAWNER_SPAWN_COUNT = (short)3;
    public static short GROUP_SPAWNER_MAX_NEARBY_ENTITIES = (short)6;
    public static short GROUP_SPAWNER_REQUIRED_PLAYER_RANGE = (short)12;
    public static short GROUP_SPAWNER_SPAWN_RANGE = (short)6;
    public static short SINGLE_SPAWNER_DELAY = (short)600;
    public static short SINGLE_SPAWNER_MIN_SPAWN_DELAY = (short)3000;
    public static short SINGLE_SPAWNER_MAX_SPAWN_DELAY = (short)9000;
    public static short SINGLE_SPAWNER_SPAWN_COUNT = 1;
    public static short SINGLE_SPAWNER_MAX_NEARBY_ENTITIES = 1;
    public static short SINGLE_SPAWNER_REQUIRED_PLAYER_RANGE = (short)8;
    public static short SINGLE_SPAWNER_SPAWN_RANGE = (short)4;

    public static void registerConfig() {
        SpawnerTypeConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        SpawnerTypeConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = SpawnerTypeConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = SpawnerTypeConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        BOSS_SPAWNER_DELAY = SpawnerTypeConfig.parseConfigValue(properties, "BossSpawner:Delay", BOSS_SPAWNER_DELAY);
        BOSS_SPAWNER_MIN_SPAWN_DELAY = SpawnerTypeConfig.parseConfigValue(properties, "BossSpawner:MinSpawnDelay", BOSS_SPAWNER_MIN_SPAWN_DELAY);
        BOSS_SPAWNER_MAX_SPAWN_DELAY = SpawnerTypeConfig.parseConfigValue(properties, "BossSpawner:MaxSpawnDelay", BOSS_SPAWNER_MAX_SPAWN_DELAY);
        BOSS_SPAWNER_SPAWN_COUNT = SpawnerTypeConfig.parseConfigValue(properties, "BossSpawner:SpawnCount", BOSS_SPAWNER_SPAWN_COUNT);
        BOSS_SPAWNER_MAX_NEARBY_ENTITIES = SpawnerTypeConfig.parseConfigValue(properties, "BossSpawner:MaxNearbyEntities", BOSS_SPAWNER_MAX_NEARBY_ENTITIES);
        BOSS_SPAWNER_REQUIRED_PLAYER_RANGE = SpawnerTypeConfig.parseConfigValue(properties, "BossSpawner:RequiredPlayerRange", BOSS_SPAWNER_REQUIRED_PLAYER_RANGE);
        BOSS_SPAWNER_SPAWN_RANGE = SpawnerTypeConfig.parseConfigValue(properties, "BossSpawner:SpawnRange", BOSS_SPAWNER_SPAWN_RANGE);
        DEFAULT_SPAWNER_DELAY = SpawnerTypeConfig.parseConfigValue(properties, "DefaultSpawner:Delay", DEFAULT_SPAWNER_DELAY);
        DEFAULT_SPAWNER_MIN_SPAWN_DELAY = SpawnerTypeConfig.parseConfigValue(properties, "DefaultSpawner:MinSpawnDelay", DEFAULT_SPAWNER_MIN_SPAWN_DELAY);
        DEFAULT_SPAWNER_MAX_SPAWN_DELAY = SpawnerTypeConfig.parseConfigValue(properties, "DefaultSpawner:MaxSpawnDelay", DEFAULT_SPAWNER_MAX_SPAWN_DELAY);
        DEFAULT_SPAWNER_SPAWN_COUNT = SpawnerTypeConfig.parseConfigValue(properties, "DefaultSpawner:SpawnCount", DEFAULT_SPAWNER_SPAWN_COUNT);
        DEFAULT_SPAWNER_MAX_NEARBY_ENTITIES = SpawnerTypeConfig.parseConfigValue(properties, "DefaultSpawner:MaxNearbyEntities", DEFAULT_SPAWNER_MAX_NEARBY_ENTITIES);
        DEFAULT_SPAWNER_REQUIRED_PLAYER_RANGE = SpawnerTypeConfig.parseConfigValue(properties, "DefaultSpawner:RequiredPlayerRange", DEFAULT_SPAWNER_REQUIRED_PLAYER_RANGE);
        DEFAULT_SPAWNER_SPAWN_RANGE = SpawnerTypeConfig.parseConfigValue(properties, "DefaultSpawner:SpawnRange", DEFAULT_SPAWNER_SPAWN_RANGE);
        GROUP_SPAWNER_DELAY = SpawnerTypeConfig.parseConfigValue(properties, "GroupSpawner:Delay", GROUP_SPAWNER_DELAY);
        GROUP_SPAWNER_MIN_SPAWN_DELAY = SpawnerTypeConfig.parseConfigValue(properties, "GroupSpawner:MinSpawnDelay", GROUP_SPAWNER_MIN_SPAWN_DELAY);
        GROUP_SPAWNER_MAX_SPAWN_DELAY = SpawnerTypeConfig.parseConfigValue(properties, "GroupSpawner:MaxSpawnDelay", GROUP_SPAWNER_MAX_SPAWN_DELAY);
        GROUP_SPAWNER_SPAWN_COUNT = SpawnerTypeConfig.parseConfigValue(properties, "GroupSpawner:SpawnCount", GROUP_SPAWNER_SPAWN_COUNT);
        GROUP_SPAWNER_MAX_NEARBY_ENTITIES = SpawnerTypeConfig.parseConfigValue(properties, "GroupSpawner:MaxNearbyEntities", GROUP_SPAWNER_MAX_NEARBY_ENTITIES);
        GROUP_SPAWNER_REQUIRED_PLAYER_RANGE = SpawnerTypeConfig.parseConfigValue(properties, "GroupSpawner:RequiredPlayerRange", GROUP_SPAWNER_REQUIRED_PLAYER_RANGE);
        GROUP_SPAWNER_SPAWN_RANGE = SpawnerTypeConfig.parseConfigValue(properties, "GroupSpawner:SpawnRange", GROUP_SPAWNER_SPAWN_RANGE);
        SINGLE_SPAWNER_DELAY = SpawnerTypeConfig.parseConfigValue(properties, "SingleSpawner:Delay", SINGLE_SPAWNER_DELAY);
        SINGLE_SPAWNER_MIN_SPAWN_DELAY = SpawnerTypeConfig.parseConfigValue(properties, "SingleSpawner:MinSpawnDelay", SINGLE_SPAWNER_MIN_SPAWN_DELAY);
        SINGLE_SPAWNER_MAX_SPAWN_DELAY = SpawnerTypeConfig.parseConfigValue(properties, "SingleSpawner:MaxSpawnDelay", SINGLE_SPAWNER_MAX_SPAWN_DELAY);
        SINGLE_SPAWNER_SPAWN_COUNT = SpawnerTypeConfig.parseConfigValue(properties, "SingleSpawner:SpawnCount", SINGLE_SPAWNER_SPAWN_COUNT);
        SINGLE_SPAWNER_MAX_NEARBY_ENTITIES = SpawnerTypeConfig.parseConfigValue(properties, "SingleSpawner:MaxNearbyEntities", SINGLE_SPAWNER_MAX_NEARBY_ENTITIES);
        SINGLE_SPAWNER_REQUIRED_PLAYER_RANGE = SpawnerTypeConfig.parseConfigValue(properties, "SingleSpawner:RequiredPlayerRange", SINGLE_SPAWNER_REQUIRED_PLAYER_RANGE);
        SINGLE_SPAWNER_SPAWN_RANGE = SpawnerTypeConfig.parseConfigValue(properties, "SingleSpawner:SpawnRange", SINGLE_SPAWNER_SPAWN_RANGE);
        SpawnerTypeConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }
}

