/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureImageLoader {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String LOG_PREFIX = "[Texture Image Loader]";

    private TextureImageLoader() {
    }

    public static NativeImage getNativeImage(File file) {
        return TextureImageLoader.getNativeImage(file, false);
    }

    public static NativeImage getNativePlayerImage(File file) {
        return TextureImageLoader.getNativeImage(file, true);
    }

    public static NativeImage getNativeImage(File file, boolean legacySupport) {
        NativeImage nativeImage;
        try (FileInputStream inputStream = new FileInputStream(file);){
            nativeImage = NativeImage.read((InputStream)inputStream);
        }
        catch (Exception exception) {
            log.error("{} Unable to get native image for file {} because of:", (Object)LOG_PREFIX, (Object)file, (Object)exception);
            return null;
        }
        if (legacySupport && nativeImage.getWidth() == 64 && nativeImage.getHeight() == 32) {
            log.info("{} Processing legacy image {} from 64x32 to 64x64 ...", (Object)LOG_PREFIX, (Object)nativeImage);
            nativeImage = TextureImageLoader.getNativeImageFromLegacyImage(nativeImage);
        }
        return nativeImage;
    }

    public static NativeImage getNativeImageFromLegacyImage(NativeImage legacyNativeImage) {
        NativeImage nativeImage = new NativeImage(64, 64, true);
        nativeImage.copyFrom(legacyNativeImage);
        legacyNativeImage.close();
        nativeImage.fillRect(0, 32, 64, 32, 0);
        nativeImage.copyRect(4, 16, 16, 32, 4, 4, true, false);
        nativeImage.copyRect(8, 16, 16, 32, 4, 4, true, false);
        nativeImage.copyRect(0, 20, 24, 32, 4, 12, true, false);
        nativeImage.copyRect(4, 20, 16, 32, 4, 12, true, false);
        nativeImage.copyRect(8, 20, 8, 32, 4, 12, true, false);
        nativeImage.copyRect(12, 20, 16, 32, 4, 12, true, false);
        nativeImage.copyRect(44, 16, -8, 32, 4, 4, true, false);
        nativeImage.copyRect(48, 16, -8, 32, 4, 4, true, false);
        nativeImage.copyRect(40, 20, 0, 32, 4, 12, true, false);
        nativeImage.copyRect(44, 20, -8, 32, 4, 12, true, false);
        nativeImage.copyRect(48, 20, -16, 32, 4, 12, true, false);
        nativeImage.copyRect(52, 20, -8, 32, 4, 12, true, false);
        return nativeImage;
    }
}

