/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.screen;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.data.render.EntityRenderOverrides;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class EntityScreenRenderer {
    protected EntityScreenRenderer() {
    }

    public static void renderEntity(GuiGraphics guiGraphics, EasyNPC<?> easyNPC, EntityRenderConfig config, float mouseX, float mouseY) {
        if (easyNPC == null || easyNPC.getLivingEntity() == null) {
            return;
        }
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        EntityRenderState backupState = new EntityRenderState(livingEntity, easyNPC);
        EntityScreenRenderer.applyRenderModifications(easyNPC, config);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)config.left(), (int)config.top(), (int)config.right(), (int)config.bottom(), (int)config.scale(), (float)config.yOffset(), (float)mouseX, (float)mouseY, (LivingEntity)livingEntity);
        EntityScreenRenderer.restoreEntityState(easyNPC, backupState);
    }

    protected static void applyRenderModifications(EasyNPC<?> easyNPC, EntityRenderConfig config) {
        ModelDataCapable modelData;
        Entity entity = easyNPC.getEntity();
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        EntityRenderOverrides overrides = config.overrides();
        if (overrides.invisible() != null) {
            entity.setInvisible(overrides.invisible().booleanValue());
        }
        if (overrides.hideNameTag() != null && overrides.hideNameTag().booleanValue()) {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft != null) {
                minecraft.options.hideGui = true;
            } else {
                livingEntity.setCustomName(null);
                livingEntity.setCustomNameVisible(false);
            }
        }
        if ((modelData = easyNPC.getEasyNPCModelData()) != null) {
            if (overrides.rootRotation() != null) {
                modelData.setModelPartRotation(ModelPartType.ROOT, overrides.rootRotation());
            }
            if (overrides.rootScale() != null) {
                modelData.setModelPartScale(ModelPartType.ROOT, overrides.rootScale());
            }
            if (overrides.modelPose() != null) {
                modelData.setModelPose(overrides.modelPose());
            }
        }
        if (overrides.entityPose() != null) {
            entity.setPose(overrides.entityPose());
        }
    }

    protected static void restoreEntityState(EasyNPC<?> easyNPC, EntityRenderState backupState) {
        ModelDataCapable modelData;
        Entity entity = easyNPC.getEntity();
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        livingEntity.setCustomName(backupState.customName);
        livingEntity.setCustomNameVisible(backupState.shouldShowName);
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft != null) {
            minecraft.options.hideGui = backupState.minecraftHideGui;
        }
        if ((modelData = easyNPC.getEasyNPCModelData()) != null) {
            if (backupState.rootRotation != null) {
                modelData.setModelPartRotation(ModelPartType.ROOT, backupState.rootRotation);
            }
            if (backupState.rootScale != null) {
                modelData.setModelPartScale(ModelPartType.ROOT, backupState.rootScale);
            }
            if (backupState.modelPose != null) {
                modelData.setModelPose(backupState.modelPose);
            }
        }
        if (backupState.entityPose != null) {
            entity.setPose(backupState.entityPose);
        }
    }

    protected static class EntityRenderState {
        final Component customName;
        final boolean shouldShowName;
        final boolean minecraftHideGui;
        final CustomRotation rootRotation;
        final CustomScale rootScale;
        final ModelPose modelPose;
        final Pose entityPose;

        EntityRenderState(LivingEntity livingEntity, EasyNPC<?> easyNPC) {
            this.customName = livingEntity.getCustomName();
            this.shouldShowName = livingEntity.shouldShowName();
            Minecraft minecraft = Minecraft.getInstance();
            this.minecraftHideGui = minecraft != null ? minecraft.options.hideGui : false;
            ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
            if (modelData != null) {
                this.rootRotation = modelData.getModelPartRotation(ModelPartType.ROOT);
                this.rootScale = modelData.getModelPartScale(ModelPartType.ROOT);
                this.modelPose = modelData.getModelPose();
            } else {
                this.rootRotation = null;
                this.rootScale = null;
                this.modelPose = null;
            }
            this.entityPose = easyNPC.getEntity().getPose();
        }
    }
}

