/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCModelManager {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private final ModelPart rootModelPart;
    private final Function<ResourceLocation, RenderType> renderType;
    private final Map<ModelPartType, CustomPosition> defaultModelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    private final Map<ModelPartType, CustomRotation> defaultModelPartRotationMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
    private final Map<ModelPartType, CustomScale> defaultModelPartScaleMap = new EnumMap<ModelPartType, CustomScale>(ModelPartType.class);
    private final Map<ModelPartType, Boolean> defaultModelPartVisibilityMap = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
    private final Map<ModelPartType, ModelPart> modelPartMap = new EnumMap<ModelPartType, ModelPart>(ModelPartType.class);

    public EasyNPCModelManager(ModelPart rootModelPart) {
        this(rootModelPart, RenderType::entityCutoutNoCull);
    }

    public EasyNPCModelManager(ModelPart rootModelPart, Function<ResourceLocation, RenderType> renderType) {
        this.rootModelPart = rootModelPart;
        this.renderType = renderType;
    }

    public EasyNPCModelManager defineModelPart(ModelPartType modelPartType, String modelPartName) {
        if (this.rootModelPart != null && this.rootModelPart.hasChild(modelPartName)) {
            return this.defineModelPart(modelPartType, this.rootModelPart.getChild(modelPartName));
        }
        log.error("Model part '{}' not found for model part type '{}' in {}.", (Object)modelPartName, (Object)modelPartType.getTagName(), (Object)this.rootModelPart);
        return this;
    }

    public EasyNPCModelManager defineModelPart(ModelPartType modelPartType, ModelPart modelPart) {
        if (modelPart == null) {
            log.error("Model part for model part type '{}' is null and can't be defined.", (Object)modelPartType);
            return this;
        }
        if (!this.defaultModelPartPositionMap.containsKey((Object)modelPartType)) {
            this.setDefaultModelPartPosition(modelPartType, new CustomPosition(modelPart.x, modelPart.y, modelPart.z));
        }
        if (!this.defaultModelPartRotationMap.containsKey((Object)modelPartType)) {
            this.setDefaultModelPartRotation(modelPartType, new CustomRotation(modelPart.xRot, modelPart.yRot, modelPart.zRot));
        }
        if (!this.defaultModelPartScaleMap.containsKey((Object)modelPartType)) {
            this.setDefaultModelPartScale(modelPartType, new CustomScale(modelPart.xScale, modelPart.yScale, modelPart.zScale));
        }
        if (!this.defaultModelPartVisibilityMap.containsKey((Object)modelPartType)) {
            this.setDefaultModelPartVisibility(modelPartType, modelPart.visible);
        }
        if (!this.modelPartMap.containsKey((Object)modelPartType)) {
            this.setDefaultModelPart(modelPartType, modelPart);
        }
        return this;
    }

    public void setDefaultModelPartPosition(ModelPartType modelPartType, CustomPosition customPosition) {
        this.defaultModelPartPositionMap.put(modelPartType, customPosition);
    }

    public void setDefaultModelPartRotation(ModelPartType modelPartType, CustomRotation rotation) {
        this.defaultModelPartRotationMap.put(modelPartType, rotation);
    }

    public void setDefaultModelPartScale(ModelPartType modelPartType, CustomScale customScale) {
        this.defaultModelPartScaleMap.put(modelPartType, customScale);
    }

    public void setDefaultModelPartVisibility(ModelPartType modelPartType, boolean isVisible) {
        this.defaultModelPartVisibilityMap.put(modelPartType, isVisible);
    }

    public void setDefaultModelPart(ModelPartType modelPartType, ModelPart modelPart) {
        this.modelPartMap.put(modelPartType, modelPart);
    }

    public ModelPart getModelPart(ModelPartType modelPartType) {
        return this.modelPartMap.get((Object)modelPartType);
    }

    public boolean setupModelParts(ModelDataCapable<?> modelData, boolean applyVisibility) {
        if (modelData == null || modelData.getModelPose() == ModelPose.DEFAULT) {
            return false;
        }
        EnumMap visibilityMap = modelData.getModelPartVisibility();
        boolean hasChangedModelPart = false;
        for (Map.Entry<ModelPartType, ModelPart> entry : this.modelPartMap.entrySet()) {
            CustomScale customScale;
            CustomRotation customRotation;
            CustomPosition customPosition;
            ModelPartType partType = entry.getKey();
            ModelPart modelPart = entry.getValue();
            if (this.isOuterLayerPart(partType)) continue;
            if (applyVisibility) {
                Boolean visibility = (Boolean)visibilityMap.get((Object)partType);
                if (Boolean.FALSE.equals(visibility)) {
                    modelPart.visible = false;
                    continue;
                }
                if (Boolean.TRUE.equals(visibility) && Boolean.TRUE.equals(this.defaultModelPartVisibilityMap.get((Object)partType))) {
                    modelPart.visible = true;
                }
            }
            if ((customPosition = modelData.getModelPartPosition(partType)) != null && customPosition.hasChanged()) {
                modelPart.x += customPosition.x();
                modelPart.y += customPosition.y();
                modelPart.z += customPosition.z();
                hasChangedModelPart = true;
            }
            if ((customRotation = modelData.getModelPartRotation(partType)) != null && customRotation.hasChanged()) {
                modelPart.xRot += customRotation.x();
                modelPart.yRot += customRotation.y();
                modelPart.zRot += customRotation.z();
                hasChangedModelPart = true;
            }
            if ((customScale = modelData.getModelPartScale(partType)) == null || !customScale.hasChanged()) continue;
            CustomScale defaultScale = this.defaultModelPartScaleMap.get((Object)partType);
            if (defaultScale != null) {
                modelPart.xScale = defaultScale.x() * customScale.x();
                modelPart.yScale = defaultScale.y() * customScale.y();
                modelPart.zScale = defaultScale.z() * customScale.z();
            } else {
                modelPart.xScale = customScale.x();
                modelPart.yScale = customScale.y();
                modelPart.zScale = customScale.z();
            }
            hasChangedModelPart = true;
        }
        this.syncModelParts(modelData);
        return hasChangedModelPart;
    }

    public void syncModelParts(ModelDataCapable<?> modelData) {
        if (modelData == null || modelData.getModelPose() == ModelPose.DEFAULT) {
            return;
        }
        EnumMap visibilityMap = modelData.getModelPartVisibility();
        this.syncOuterLayer(modelData, visibilityMap, ModelPartType.HAT, ModelPartType.HEAD);
        this.syncOuterLayer(modelData, visibilityMap, ModelPartType.BODY_JACKET, ModelPartType.BODY);
        this.syncOuterLayer(modelData, visibilityMap, ModelPartType.LEFT_SLEEVE, ModelPartType.LEFT_ARM);
        this.syncOuterLayer(modelData, visibilityMap, ModelPartType.RIGHT_SLEEVE, ModelPartType.RIGHT_ARM);
        this.syncOuterLayer(modelData, visibilityMap, ModelPartType.LEFT_PANTS, ModelPartType.LEFT_LEG);
        this.syncOuterLayer(modelData, visibilityMap, ModelPartType.RIGHT_PANTS, ModelPartType.RIGHT_LEG);
    }

    private void syncOuterLayer(ModelDataCapable<?> modelData, EnumMap<ModelPartType, Boolean> visibilityMap, ModelPartType outerPartType, ModelPartType innerPartType) {
        ModelPart outerPart = this.modelPartMap.get((Object)outerPartType);
        ModelPart innerPart = this.modelPartMap.get((Object)innerPartType);
        if (outerPart == null || innerPart == null || !Boolean.TRUE.equals(this.defaultModelPartVisibilityMap.get((Object)outerPartType))) {
            return;
        }
        if (Boolean.FALSE.equals(visibilityMap.get((Object)outerPartType))) {
            outerPart.visible = false;
        } else if (outerPartType == ModelPartType.HAT && modelData.getModelType().requiresHatSync()) {
            outerPart.copyFrom(innerPart);
        } else {
            outerPart.visible = innerPart.visible;
        }
    }

    public boolean shouldCancelAnimation(ModelDataCapable<?> modelData) {
        if (modelData == null) {
            return false;
        }
        switch (modelData.getModelAnimationBehavior()) {
            case NONE: {
                return true;
            }
            case DEFAULT: {
                return modelData.getModelPose() == ModelPose.CUSTOM;
            }
        }
        int modifiedCriticalParts = 0;
        int totalCriticalParts = 0;
        for (ModelPartType partType : this.modelPartMap.keySet()) {
            if (!this.isCriticalAnimationPart(partType)) continue;
            ++totalCriticalParts;
            CustomRotation rotation = modelData.getModelPartRotation(partType);
            CustomPosition position = modelData.getModelPartPosition(partType);
            CustomScale scale = modelData.getModelPartScale(partType);
            if (!(rotation != null && rotation.hasChanged() || position != null && position.hasChanged()) && (scale == null || !scale.hasChanged())) continue;
            ++modifiedCriticalParts;
        }
        return totalCriticalParts > 0 && modifiedCriticalParts >= totalCriticalParts;
    }

    private boolean isCriticalAnimationPart(ModelPartType partType) {
        return partType == ModelPartType.HEAD || partType == ModelPartType.RIGHT_ARM || partType == ModelPartType.LEFT_ARM || partType == ModelPartType.RIGHT_LEG || partType == ModelPartType.LEFT_LEG || partType == ModelPartType.RIGHT_FRONT_LEG || partType == ModelPartType.LEFT_FRONT_LEG || partType == ModelPartType.RIGHT_HIND_LEG || partType == ModelPartType.LEFT_HIND_LEG || partType == ModelPartType.ARMS;
    }

    private boolean isOuterLayerPart(ModelPartType partType) {
        return partType == ModelPartType.HAT || partType == ModelPartType.LEFT_SLEEVE || partType == ModelPartType.RIGHT_SLEEVE || partType == ModelPartType.LEFT_PANTS || partType == ModelPartType.RIGHT_PANTS || partType == ModelPartType.BODY_JACKET;
    }

    public void applySelectiveChanges(ModelDataCapable<?> modelData) {
        if (modelData == null) {
            return;
        }
        for (Map.Entry<ModelPartType, ModelPart> entry : this.modelPartMap.entrySet()) {
            CustomPosition customPosition;
            CustomRotation customRotation;
            ModelPartType partType = entry.getKey();
            ModelPart modelPart = entry.getValue();
            if (partType == ModelPartType.HAT) continue;
            CustomScale customScale = modelData.getModelPartScale(partType);
            if (customScale != null && customScale.hasChanged()) {
                CustomScale defaultScale = this.defaultModelPartScaleMap.get((Object)partType);
                if (defaultScale != null) {
                    modelPart.xScale = defaultScale.x() * customScale.x();
                    modelPart.yScale = defaultScale.y() * customScale.y();
                    modelPart.zScale = defaultScale.z() * customScale.z();
                } else {
                    modelPart.xScale = customScale.x();
                    modelPart.yScale = customScale.y();
                    modelPart.zScale = customScale.z();
                }
            }
            if ((customRotation = modelData.getModelPartRotation(partType)) != null && customRotation.hasChanged()) {
                modelPart.xRot += customRotation.x();
                modelPart.yRot += customRotation.y();
                modelPart.zRot += customRotation.z();
            }
            if ((customPosition = modelData.getModelPartPosition(partType)) == null || !customPosition.hasChanged()) continue;
            modelPart.x += customPosition.x();
            modelPart.y += customPosition.y();
            modelPart.z += customPosition.z();
        }
        this.syncModelParts(modelData);
    }

    public void applyVisibilityChanges(ModelDataCapable<?> modelData) {
        if (modelData == null) {
            return;
        }
        EnumMap visibilityMap = modelData.getModelPartVisibility();
        for (Map.Entry<ModelPartType, ModelPart> entry : this.modelPartMap.entrySet()) {
            ModelPartType partType = entry.getKey();
            ModelPart modelPart = entry.getValue();
            if (this.isOuterLayerPart(partType)) continue;
            Boolean visibility = (Boolean)visibilityMap.get((Object)partType);
            if (Boolean.FALSE.equals(visibility)) {
                modelPart.visible = false;
                continue;
            }
            if (!Boolean.TRUE.equals(visibility) || !Boolean.TRUE.equals(this.defaultModelPartVisibilityMap.get((Object)partType))) continue;
            modelPart.visible = true;
        }
        this.syncModelParts(modelData);
    }

    public void resetModelParts() {
        for (Map.Entry<ModelPartType, ModelPart> entry : this.modelPartMap.entrySet()) {
            ModelPartType modelPartType = entry.getKey();
            ModelPart modelPartToRest = entry.getValue();
            if (this.isOuterLayerPart(modelPartType)) continue;
            CustomPosition customPosition = this.defaultModelPartPositionMap.get((Object)modelPartType);
            CustomRotation customRotation = this.defaultModelPartRotationMap.get((Object)modelPartType);
            CustomScale customScale = this.defaultModelPartScaleMap.get((Object)modelPartType);
            Boolean isVisible = this.defaultModelPartVisibilityMap.get((Object)modelPartType);
            if (customPosition != null) {
                modelPartToRest.setPos(customPosition.x(), customPosition.y(), customPosition.z());
            }
            if (customRotation != null) {
                modelPartToRest.setRotation(customRotation.x(), customRotation.y(), customRotation.z());
            }
            if (customScale != null) {
                modelPartToRest.xScale = customScale.x();
                modelPartToRest.yScale = customScale.y();
                modelPartToRest.zScale = customScale.z();
            }
            if (isVisible == null) continue;
            modelPartToRest.visible = isVisible;
        }
    }
}

