/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class PlayerOptionData
extends SavedData {
    private final HashMap<UUID, HashMap<ResourceLocation, byte[]>> playerOptions = new HashMap();

    public static SavedData.Factory<PlayerOptionData> factory() {
        return new SavedData.Factory(PlayerOptionData::new, PlayerOptionData::load, null);
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        for (Map.Entry<UUID, HashMap<ResourceLocation, byte[]>> playerEntry : this.playerOptions.entrySet()) {
            CompoundTag playerTag = new CompoundTag();
            UUID playerUUID = playerEntry.getKey();
            for (Map.Entry<ResourceLocation, byte[]> resourceEntry : playerEntry.getValue().entrySet()) {
                ResourceLocation resource = resourceEntry.getKey();
                byte[] data = resourceEntry.getValue();
                playerTag.putByteArray(resource.toString(), data);
            }
            tag.put(playerUUID.toString(), (Tag)playerTag);
        }
        return tag;
    }

    public HashMap<ResourceLocation, byte[]> getPlayerOptions(ServerPlayer player) {
        return this.playerOptions.getOrDefault(player.getUUID(), new HashMap());
    }

    public void setPlayerOptions(ServerPlayer player, HashMap<ResourceLocation, byte[]> playerOptions) {
        this.playerOptions.put(player.getUUID(), playerOptions);
        this.setDirty();
    }

    public static PlayerOptionData load(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        PlayerOptionData data = new PlayerOptionData();
        for (String playerUUIDString : tag.getAllKeys()) {
            UUID playerUUID = UUID.fromString(playerUUIDString);
            CompoundTag playerTag = tag.getCompound(playerUUIDString);
            HashMap<ResourceLocation, byte[]> resourceMap = new HashMap<ResourceLocation, byte[]>();
            for (String resourceKey : playerTag.getAllKeys()) {
                ResourceLocation resourceLocation = ResourceLocation.parse((String)resourceKey);
                byte[] array = playerTag.getByteArray(resourceKey);
                resourceMap.put(resourceLocation, array);
            }
            data.playerOptions.put(playerUUID, resourceMap);
        }
        return data;
    }
}

