/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class MultiLineTooltip
extends Tooltip {
    private final Component[] components;

    public MultiLineTooltip(Component ... message) {
        super(message[0], message[0]);
        this.components = message;
    }

    @NotNull
    public List<FormattedCharSequence> toCharSequence(@NotNull Minecraft minecraft) {
        Language language = Language.getInstance();
        if (this.cachedTooltip == null || language != this.splitWithLanguage) {
            ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
            for (Component component : this.components) {
                List split = MultiLineTooltip.splitTooltip((Minecraft)minecraft, (Component)component);
                lines.addAll(split);
                if (!split.isEmpty()) continue;
                lines.add(Component.empty().getVisualOrderText());
            }
            this.cachedTooltip = lines;
            this.splitWithLanguage = language;
        }
        return this.cachedTooltip;
    }
}

