/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomOptionTooltip
extends Tooltip {
    @Nullable
    private final Tooltip fallback;
    private final String original;
    private final String current;

    public CustomOptionTooltip(@Nullable Tooltip fallback, String original, String current) {
        super((Component)(fallback != null ? fallback.message : Component.empty()), (Component)(fallback != null ? fallback.narration : Component.empty()));
        if (fallback instanceof CustomOptionTooltip) {
            CustomOptionTooltip customOptionTooltip = (CustomOptionTooltip)fallback;
            this.fallback = customOptionTooltip.fallback;
        } else {
            this.fallback = fallback;
        }
        this.original = original;
        this.current = current;
    }

    @NotNull
    public List<FormattedCharSequence> toCharSequence(@NotNull Minecraft minecraft) {
        if (this.original.equals(this.current) && this.fallback != null) {
            return this.fallback.toCharSequence(minecraft);
        }
        Language language = Language.getInstance();
        if (this.cachedTooltip == null || language != this.splitWithLanguage) {
            ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>(CustomOptionTooltip.splitTooltip((Minecraft)minecraft, (Component)this.message));
            tooltip.add(Component.empty().getVisualOrderText());
            tooltip.add(Component.translatable((String)"message.charta.original", (Object[])new Object[]{Component.literal((String)this.original).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.RED).getVisualOrderText());
            tooltip.add(Component.translatable((String)"message.charta.current", (Object[])new Object[]{Component.literal((String)this.current).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.RED).getVisualOrderText());
            this.cachedTooltip = tooltip;
            this.splitWithLanguage = language;
        }
        return this.cachedTooltip;
    }
}

