/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.lucaargolo.charta.client.ChartaClient;
import dev.lucaargolo.charta.compat.IrisCompat;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.game.Suit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class ChartaGuiGraphics {
    public static void blitSuitAndGlow(GuiGraphics parent, Deck deck, Suit suit, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        ResourceLocation textureLocation = deck.getSuitTexture(suit, false);
        ResourceLocation glowLocation = deck.getSuitTexture(suit, true);
        ChartaGuiGraphics.blitImage(parent, textureLocation, x, y, u, v, width, height, textureWidth, textureHeight);
        ChartaClient.getGlowRenderTarget().bindWrite(false);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ChartaGuiGraphics.blitImage(parent, textureLocation, x, y, u, v, width, height, textureWidth, textureHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ChartaGuiGraphics.blitImageGlow(parent, glowLocation, x, y, u, v, width, height, textureWidth, textureHeight);
        Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
    }

    public static void blitWhiteSuitAndGlow(GuiGraphics parent, Deck deck, Suit suit, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        ResourceLocation textureLocation = deck.getSuitTexture(suit, false);
        ResourceLocation glowLocation = deck.getSuitTexture(suit, true);
        ChartaGuiGraphics.blitWhiteImage(parent, textureLocation, x, y, u, v, width, height, textureWidth, textureHeight);
        ChartaClient.getGlowRenderTarget().bindWrite(false);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ChartaGuiGraphics.blitWhiteImage(parent, textureLocation, x, y, u, v, width, height, textureWidth, textureHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ChartaGuiGraphics.blitWhiteImageGlow(parent, glowLocation, x, y, u, v, width, height, textureWidth, textureHeight);
        Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
    }

    public static void blitImage(GuiGraphics parent, ResourceLocation textureLocation, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
        if (IrisCompat.isPresent()) {
            RenderSystem.setShader(ChartaClient::getImageArgbShader);
        } else {
            RenderSystem.setShader(ChartaClient::getImageShader);
        }
        ChartaGuiGraphics.innerBlit(parent, x, x + width, y, y + height, (u + 0.0f) / textureWidth, (u + width) / textureWidth, (v + 0.0f) / textureHeight, (v + height) / textureHeight);
    }

    public static void blitWhiteImage(GuiGraphics parent, ResourceLocation textureLocation, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
        if (IrisCompat.isPresent()) {
            RenderSystem.setShader(ChartaClient::getWhiteImageArgbShader);
        } else {
            RenderSystem.setShader(ChartaClient::getWhiteImageShader);
        }
        ChartaGuiGraphics.innerBlit(parent, x, x + width, y, y + height, (u + 0.0f) / textureWidth, (u + width) / textureWidth, (v + 0.0f) / textureHeight, (v + height) / textureHeight);
    }

    public static void blitImageGlow(GuiGraphics parent, ResourceLocation textureLocation, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
        if (IrisCompat.isPresent()) {
            RenderSystem.setShader(ChartaClient::getImageArgbShader);
        } else {
            RenderSystem.setShader(ChartaClient::getImageGlowShader);
        }
        ChartaGuiGraphics.innerBlit(parent, x, x + width, y, y + height, (u + 0.0f) / textureWidth, (u + width) / textureWidth, (v + 0.0f) / textureHeight, (v + height) / textureHeight);
    }

    public static void blitWhiteImageGlow(GuiGraphics parent, ResourceLocation textureLocation, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
        if (IrisCompat.isPresent()) {
            RenderSystem.setShader(ChartaClient::getWhiteImageArgbShader);
        } else {
            RenderSystem.setShader(ChartaClient::getWhiteImageGlowShader);
        }
        ChartaGuiGraphics.innerBlit(parent, x, x + width, y, y + height, (u + 0.0f) / textureWidth, (u + width) / textureWidth, (v + 0.0f) / textureHeight, (v + height) / textureHeight);
    }

    public static void blitCard(GuiGraphics parent, ResourceLocation textureLocation, float x, float y, float width, float height) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
        if (IrisCompat.isPresent()) {
            RenderSystem.setShader(ChartaClient::getCardArgbShader);
        } else {
            RenderSystem.setShader(ChartaClient::getCardShader);
        }
        ChartaGuiGraphics.innerBlit(parent, x, x + width, y, y + height, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public static void blitCardGlow(GuiGraphics parent, ResourceLocation textureLocation, float x, float y, float width, float height) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
        if (IrisCompat.isPresent()) {
            RenderSystem.setShader(ChartaClient::getCardArgbShader);
        } else {
            RenderSystem.setShader(ChartaClient::getCardGlowShader);
        }
        ChartaGuiGraphics.innerBlit(parent, x, x + width, y, y + height, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public static void blitPerspective(GuiGraphics parent, ResourceLocation textureLocation, float x, float y, float width, float height) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
        RenderSystem.setShader(ChartaClient::getPerspectiveShader);
        ChartaGuiGraphics.innerBlit(parent, x, x + width, y, y + height, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public static void blitGrayscale(GuiGraphics parent, ResourceLocation textureLocation, float x, float y, float width, float height) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
        RenderSystem.setShader(ChartaClient::getGrayscaleShader);
        ChartaGuiGraphics.innerBlit(parent, x, x + width, y, y + height, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public static void innerBlit(GuiGraphics parent, float x1, float x2, float y1, float y2, float minU, float maxU, float minV, float maxV) {
        RenderSystem.enableBlend();
        Matrix4f matrix4f = parent.pose().last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(matrix4f, x1, y1, 0.0f).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f, x1, y2, 0.0f).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f, x2, y2, 0.0f).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f, x2, y1, 0.0f).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }
}

