/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.utils;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.game.CardPlayer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public record CardPlayerHead(ResourceLocation texture, float u, float v, float uOffset, float vOffset, float width, float height) {
    public static final CardPlayerHead UNKNOWN = new CardPlayerHead(Charta.id("textures/misc/unknown.png"), 0.0f, 0.0f, 12.0f, 12.0f, 12.0f, 12.0f);
    public static final CardPlayerHead ROBOT = new CardPlayerHead(Charta.id("textures/misc/robot.png"), 0.0f, 0.0f, 12.0f, 12.0f, 12.0f, 12.0f);
    private static final Map<UUID, CardPlayerHead> playerCache = new HashMap<UUID, CardPlayerHead>();
    private static final Map<EntityType<?>, CardPlayerHead> cache = new HashMap();

    public static void renderHead(GuiGraphics graphics, int x, int y, CardPlayer player) {
        CardPlayerHead head = player.getHead();
        float xOffset = (24.0f - head.uOffset * 2.0f) / 2.0f;
        float yOffset = (24.0f - head.vOffset * 2.0f) / 2.0f;
        graphics.pose().pushPose();
        graphics.pose().translate((float)((int)((float)x + xOffset)), (float)((int)((float)y + yOffset)), 0.0f);
        graphics.pose().scale(2.0f, 2.0f, 2.0f);
        graphics.blit(head.texture(), 0, 0, head.u(), head.v(), (int)head.uOffset(), (int)head.vOffset(), (int)head.width(), (int)head.height());
        graphics.pose().popPose();
    }

    public static CardPlayerHead get(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return playerCache.computeIfAbsent(entity.getUUID(), u -> CardPlayerHead.getPlayer(player));
        }
        return cache.computeIfAbsent(entity.getType(), t -> CardPlayerHead.getOther(entity));
    }

    private static CardPlayerHead getPlayer(Player player) {
        PlayerInfo info;
        Minecraft minecraft = Minecraft.getInstance();
        ClientPacketListener connection = minecraft.getConnection();
        if (connection != null && (info = connection.getPlayerInfo(player.getUUID())) != null) {
            return new CardPlayerHead(info.getSkin().texture(), 8.0f, 8.0f, 8.0f, 8.0f, 64.0f, 64.0f);
        }
        return UNKNOWN;
    }

    private static CardPlayerHead getOther(LivingEntity entity) {
        Minecraft minecraft = Minecraft.getInstance();
        ResourceLocation id = entity.getType().builtInRegistryHolder().key().location();
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("textures/head/" + id.getPath() + ".png"));
        AbstractTexture texture = minecraft.getTextureManager().getTexture(location);
        try {
            texture.load(minecraft.getResourceManager());
            return new CardPlayerHead(location, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
        }
        catch (Exception ignored) {
            return UNKNOWN;
        }
    }
}

