/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.resources;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.utils.SuitImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public class SuitImageResource
implements ResourceManagerReloadListener {
    private HashMap<ResourceLocation, SuitImage> images = new HashMap();

    public void onResourceManagerReload(ResourceManager manager) {
        this.images.clear();
        manager.listResources("images/suit", id -> id.getPath().endsWith(".mcsuit")).forEach((id, resource) -> {
            try (InputStream stream = resource.open();){
                ResourceLocation location = id.withPath(s -> s.replace("images/suit/", "").replace(".mcsuit", ""));
                this.images.put(location, SuitImage.decompress(stream.readAllBytes()));
            }
            catch (IOException e) {
                Charta.LOGGER.error("Error while reading card suit {} :", id, (Object)e);
            }
        });
        Charta.LOGGER.info("Loaded {} card suits", (Object)this.images.size());
    }

    public HashMap<ResourceLocation, SuitImage> getImages() {
        return this.images;
    }

    public void setImages(HashMap<ResourceLocation, SuitImage> images) {
        this.images = images;
    }
}

