/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.resources;

import com.mojang.datafixers.util.Either;
import dev.lucaargolo.charta.Charta;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.Renderer;
import org.commonmark.renderer.html.AttributeProviderContext;
import org.commonmark.renderer.html.CoreHtmlNodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlNodeRendererFactory;
import org.commonmark.renderer.html.HtmlWriter;
import org.commonmark.renderer.html.UrlSanitizer;
import org.jetbrains.annotations.Nullable;

public class MarkdownResource
implements ResourceManagerReloadListener {
    private final HashMap<ResourceLocation, List<Either<String, String>>> markdowns = new HashMap();
    private final Parser parser = Parser.builder().build();

    public void onResourceManagerReload(ResourceManager manager) {
        this.markdowns.clear();
        manager.listResources("lang/charta_md", id -> id.getPath().endsWith(".md")).forEach((id, resource) -> {
            try (InputStream stream = resource.open();){
                ResourceLocation location = id.withPath(s -> s.replace("lang/charta_md/", "").replace(".md", ""));
                String markdown = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                Node document = this.parser.parse(markdown);
                ObjectCollector renderer = new ObjectCollector();
                renderer.render(document, null);
                this.markdowns.put(location, renderer.getNodes());
            }
            catch (IOException e) {
                Charta.LOGGER.error("Error while reading markdown {} :", id, (Object)e);
            }
        });
        Charta.LOGGER.info("Loaded {} markdowns", (Object)this.markdowns.size());
    }

    @Nullable
    public List<Either<String, String>> getMarkdown(ResourceLocation location) {
        return this.markdowns.get(location);
    }

    public static class ObjectCollector
    implements Renderer {
        private final String softBreak;
        private final boolean escapeHtml;
        private final boolean percentEncodeUrls;
        private final List<HtmlNodeRendererFactory> nodeRendererFactories;
        private final ObjectWriter objectWriter = new ObjectWriter();

        public ObjectCollector() {
            this.softBreak = "\n";
            this.escapeHtml = true;
            this.percentEncodeUrls = true;
            this.nodeRendererFactories = new ArrayList<HtmlNodeRendererFactory>(1);
            this.nodeRendererFactories.add(CoreHtmlNodeRenderer::new);
        }

        public void render(Node node, Appendable output) {
            RendererContext context = new RendererContext(this.objectWriter);
            context.render(node);
        }

        public String render(Node node) {
            throw new AssertionError((Object)"This is not a renderer");
        }

        public List<Either<String, String>> getNodes() {
            return this.objectWriter.getNodes();
        }

        private class RendererContext
        implements HtmlNodeRendererContext,
        AttributeProviderContext {
            private final HtmlWriter htmlWriter;
            private final NodeRendererMap nodeRendererMap = new NodeRendererMap();

            private RendererContext(HtmlWriter htmlWriter) {
                this.htmlWriter = htmlWriter;
                for (int i = ObjectCollector.this.nodeRendererFactories.size() - 1; i >= 0; --i) {
                    HtmlNodeRendererFactory nodeRendererFactory = ObjectCollector.this.nodeRendererFactories.get(i);
                    NodeRenderer nodeRenderer = nodeRendererFactory.create((HtmlNodeRendererContext)this);
                    this.nodeRendererMap.add(nodeRenderer);
                }
            }

            public boolean shouldEscapeHtml() {
                return ObjectCollector.this.escapeHtml;
            }

            public boolean shouldOmitSingleParagraphP() {
                return false;
            }

            public boolean shouldSanitizeUrls() {
                return false;
            }

            public UrlSanitizer urlSanitizer() {
                return null;
            }

            public String encodeUrl(String url) {
                if (ObjectCollector.this.percentEncodeUrls) {
                    try {
                        ClassLoader classLoader = MarkdownResource.class.getModule().getLayer().findModule("org.commonmark").get().getClassLoader();
                        Class<?> escapingClass = classLoader.loadClass("org.commonmark.internal.util.Escaping");
                        Method encodeMethod = escapingClass.getDeclaredMethod("percentEncodeUrl", new Class[0]);
                        return (String)encodeMethod.invoke(null, url);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to encode url", e);
                    }
                }
                return url;
            }

            public Map<String, String> extendAttributes(Node node, String tagName, Map<String, String> attributes) {
                return new LinkedHashMap<String, String>(attributes);
            }

            public HtmlWriter getWriter() {
                return this.htmlWriter;
            }

            public String getSoftbreak() {
                return ObjectCollector.this.softBreak;
            }

            public void render(Node node) {
                this.nodeRendererMap.render(node);
            }
        }
    }

    public static class ObjectWriter
    extends HtmlWriter {
        private final List<Either<String, String>> nodes = new ArrayList<Either<String, String>>();

        public ObjectWriter() {
            super((Appendable)new StringBuilder());
        }

        public void raw(String s) {
            this.nodes.add((Either<String, String>)Either.right((Object)s));
        }

        public void text(String text) {
            this.nodes.add((Either<String, String>)Either.right((Object)text));
        }

        public void tag(String name) {
            this.nodes.add((Either<String, String>)Either.left((Object)name));
        }

        public void tag(String name, Map<String, String> attrs) {
            this.nodes.add((Either<String, String>)Either.left((Object)name));
        }

        public void tag(String name, Map<String, String> attrs, boolean voidElement) {
            this.tag(name, attrs);
        }

        public void line() {
        }

        protected void append(String s) {
            this.nodes.add((Either<String, String>)Either.right((Object)s));
        }

        public List<Either<String, String>> getNodes() {
            return this.nodes;
        }
    }

    public static class NodeRendererMap {
        private final List<NodeRenderer> nodeRenderers = new ArrayList<NodeRenderer>();
        private final Map<Class<? extends Node>, NodeRenderer> renderers = new HashMap<Class<? extends Node>, NodeRenderer>(32);

        public void add(NodeRenderer nodeRenderer) {
            this.nodeRenderers.add(nodeRenderer);
            for (Class nodeType : nodeRenderer.getNodeTypes()) {
                this.renderers.putIfAbsent(nodeType, nodeRenderer);
            }
        }

        public void render(Node node) {
            NodeRenderer nodeRenderer = this.renderers.get(node.getClass());
            if (nodeRenderer != null) {
                nodeRenderer.render(node);
            }
        }

        public void beforeRoot(Node node) {
            this.nodeRenderers.forEach(r -> r.beforeRoot(node));
        }

        public void afterRoot(Node node) {
            this.nodeRenderers.forEach(r -> r.afterRoot(node));
        }
    }
}

