/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.resources;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.utils.CardImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public class CardImageResource
implements ResourceManagerReloadListener {
    private HashMap<ResourceLocation, CardImage> images = new HashMap();
    private final String path;

    public CardImageResource(String path) {
        this.path = path;
    }

    public void onResourceManagerReload(ResourceManager manager) {
        this.images.clear();
        String fullPath = "images/" + this.path;
        manager.listResources(fullPath, id -> id.getPath().endsWith(".mccard")).forEach((id, resource) -> {
            try (InputStream stream = resource.open();){
                ResourceLocation location = id.withPath(s -> s.replace(fullPath + "/", "").replace(".mccard", ""));
                this.images.put(location, CardImage.decompress(stream.readAllBytes()));
            }
            catch (IOException e) {
                Charta.LOGGER.error("Error while reading {} image {} :", new Object[]{this.path, id, e});
            }
        });
        Charta.LOGGER.info("Loaded {} {} images", (Object)this.images.size(), (Object)this.path);
    }

    public HashMap<ResourceLocation, CardImage> getImages() {
        return this.images;
    }

    public void setImages(HashMap<ResourceLocation, CardImage> images) {
        this.images = images;
    }
}

