/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.network;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record UpdateCardContainerSlotPayload(int containerId, int stateId, int slotId, List<Card> cards) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateCardContainerSlotPayload> TYPE = new CustomPacketPayload.Type(Charta.id("update_card_container_slot"));
    public static final StreamCodec<ByteBuf, UpdateCardContainerSlotPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, UpdateCardContainerSlotPayload::containerId, (StreamCodec)ByteBufCodecs.INT, UpdateCardContainerSlotPayload::stateId, (StreamCodec)ByteBufCodecs.INT, UpdateCardContainerSlotPayload::slotId, (StreamCodec)ByteBufCodecs.collection(NonNullList::createWithCapacity, Card.STREAM_CODEC), UpdateCardContainerSlotPayload::cards, UpdateCardContainerSlotPayload::new);

    public static void handleClient(UpdateCardContainerSlotPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof AbstractCardMenu) {
                AbstractCardMenu cardMenu = (AbstractCardMenu)patt0$temp;
                if (cardMenu.containerId == payload.containerId) {
                    cardMenu.setCards(payload.slotId, payload.stateId, payload.cards);
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

