/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.network;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record UpdateCardContainerCarriedPayload(int containerId, int stateId, List<Card> cards) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateCardContainerCarriedPayload> TYPE = new CustomPacketPayload.Type(Charta.id("update_card_container_carried"));
    public static final StreamCodec<ByteBuf, UpdateCardContainerCarriedPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, UpdateCardContainerCarriedPayload::containerId, (StreamCodec)ByteBufCodecs.INT, UpdateCardContainerCarriedPayload::stateId, (StreamCodec)ByteBufCodecs.collection(i -> new LinkedList(), Card.STREAM_CODEC), UpdateCardContainerCarriedPayload::cards, UpdateCardContainerCarriedPayload::new);

    public static void handleClient(UpdateCardContainerCarriedPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof AbstractCardMenu) {
                AbstractCardMenu cardMenu = (AbstractCardMenu)patt0$temp;
                if (cardMenu.containerId == payload.containerId) {
                    cardMenu.setCarriedCards(payload.stateId, new GameSlot(payload.cards));
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

