/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.network;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.ChartaClient;
import dev.lucaargolo.charta.utils.PlayerOptionData;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PlayerOptionsPayload(HashMap<ResourceLocation, byte[]> playerOptions) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayerOptionsPayload> TYPE = new CustomPacketPayload.Type(Charta.id("player_options"));
    public static StreamCodec<ByteBuf, PlayerOptionsPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)ByteBufCodecs.BYTE_ARRAY), PlayerOptionsPayload::playerOptions, PlayerOptionsPayload::new);

    public static void handleBoth(PlayerOptionsPayload payload, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            PlayerOptionsPayload.handleServer(payload, context);
        } else {
            PlayerOptionsPayload.handleClient(payload, context);
        }
    }

    public static void handleClient(PlayerOptionsPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ChartaClient.LOCAL_OPTIONS.clear();
            ChartaClient.LOCAL_OPTIONS.putAll(payload.playerOptions);
        });
    }

    public static void handleServer(PlayerOptionsPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                PlayerOptionData data = (PlayerOptionData)serverPlayer.server.overworld().getDataStorage().computeIfAbsent(PlayerOptionData.factory(), "charta_player_options");
                data.setPlayerOptions(serverPlayer, payload.playerOptions());
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

