/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.network;

import com.mojang.serialization.Codec;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.game.fun.FunGame;
import dev.lucaargolo.charta.game.fun.FunMenu;
import dev.lucaargolo.charta.game.fun.FunScreen;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record LastFunPayload(ItemStack deckStack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LastFunPayload> TYPE = new CustomPacketPayload.Type(Charta.id("last_fun"));
    private static final StreamCodec<ByteBuf, ItemStack> STACK_STREAM = ByteBufCodecs.fromCodecTrusted((Codec)ItemStack.OPTIONAL_CODEC);
    public static StreamCodec<ByteBuf, LastFunPayload> STREAM_CODEC = StreamCodec.composite(STACK_STREAM, LastFunPayload::deckStack, LastFunPayload::new);

    public LastFunPayload() {
        this(ItemStack.EMPTY);
    }

    public static void handleBoth(LastFunPayload payload, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            LastFunPayload.handleServer(payload, context);
        } else {
            LastFunPayload.handleClient(payload, context);
        }
    }

    public static void handleServer(LastFunPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AbstractContainerMenu patt0$temp = serverPlayer.containerMenu;
                if (patt0$temp instanceof FunMenu) {
                    FunMenu funMenu = (FunMenu)patt0$temp;
                    ((FunGame)funMenu.getGame()).sayLast(((LivingEntityMixed)player).charta_getCardPlayer());
                }
            }
        });
    }

    public static void handleClient(LastFunPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> LastFunPayload.displayTotemEffect(payload.deckStack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void displayTotemEffect(ItemStack deckStack) {
        Screen screen;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && mc.player != null && (screen = mc.screen) instanceof FunScreen) {
            FunScreen funScreen = (FunScreen)screen;
            mc.level.playLocalSound(mc.player.getX(), mc.player.getY(), mc.player.getZ(), SoundEvents.TOTEM_USE, mc.player.getSoundSource(), 1.0f, 1.0f, false);
            funScreen.displayItemActivation(deckStack);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

