/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.network;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.blockentity.ModBlockEntityTypes;
import dev.lucaargolo.charta.game.GameSlot;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record GameSlotPositionPayload(BlockPos pos, int index, float x, float y, float z, float angle) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GameSlotPositionPayload> TYPE = new CustomPacketPayload.Type(Charta.id("game_slot_position"));
    public static StreamCodec<ByteBuf, GameSlotPositionPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, GameSlotPositionPayload::pos, (StreamCodec)ByteBufCodecs.INT, GameSlotPositionPayload::index, (StreamCodec)ByteBufCodecs.FLOAT, GameSlotPositionPayload::x, (StreamCodec)ByteBufCodecs.FLOAT, GameSlotPositionPayload::y, (StreamCodec)ByteBufCodecs.FLOAT, GameSlotPositionPayload::z, (StreamCodec)ByteBufCodecs.FLOAT, GameSlotPositionPayload::angle, GameSlotPositionPayload::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleClient(GameSlotPositionPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> GameSlotPositionPayload.updateGameSlot(payload));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void updateGameSlot(GameSlotPositionPayload payload) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level != null) {
            level.getBlockEntity(payload.pos, (BlockEntityType)ModBlockEntityTypes.CARD_TABLE.get()).ifPresent(cardTable -> {
                GameSlot slot = cardTable.getSlot(payload.index);
                slot.setX(payload.x);
                slot.setY(payload.y);
                slot.setZ(payload.z);
                slot.setAngle(payload.angle);
            });
        }
    }
}

