/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.network;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.gui.screens.ConfirmScreen;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record GameLeavePayload() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GameLeavePayload> TYPE = new CustomPacketPayload.Type(Charta.id("game_leave"));
    public static StreamCodec<ByteBuf, GameLeavePayload> STREAM_CODEC = StreamCodec.unit((Object)new GameLeavePayload());

    public static void handleBoth(GameLeavePayload payload, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            GameLeavePayload.handleServer(payload, context);
        } else {
            GameLeavePayload.handleClient(payload, context);
        }
    }

    public static void handleServer(GameLeavePayload payload, IPayloadContext context) {
        context.enqueueWork(() -> context.player().stopRiding());
    }

    public static void handleClient(GameLeavePayload payload, IPayloadContext context) {
        context.enqueueWork(GameLeavePayload::openExitScreen);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openExitScreen() {
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.setScreen((Screen)new ConfirmScreen(null, (Component)Component.translatable((String)"message.charta.leaving_game"), true, () -> {
            if (minecraft.player != null) {
                minecraft.player.stopRiding();
                PacketDistributor.sendToServer((CustomPacketPayload)new GameLeavePayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

