/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.network;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.blockentity.ModBlockEntityTypes;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record CardTableSelectGamePayload(BlockPos pos, ResourceLocation gameId, byte[] options) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CardTableSelectGamePayload> TYPE = new CustomPacketPayload.Type(Charta.id("card_table_select_game"));
    public static final StreamCodec<ByteBuf, CardTableSelectGamePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, CardTableSelectGamePayload::pos, (StreamCodec)ResourceLocation.STREAM_CODEC, CardTableSelectGamePayload::gameId, (StreamCodec)ByteBufCodecs.BYTE_ARRAY, CardTableSelectGamePayload::options, CardTableSelectGamePayload::new);

    public static void handleServer(CardTableSelectGamePayload payload, IPayloadContext context) {
        context.enqueueWork(() -> context.player().level().getBlockEntity(payload.pos(), (BlockEntityType)ModBlockEntityTypes.CARD_TABLE.get()).ifPresent(table -> {
            if (table.getGame() == null || table.getGame().isGameOver()) {
                Component result = table.startGame(payload.gameId(), payload.options());
                context.player().displayClientMessage(result, true);
            }
        }));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

