/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.network;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.ChartaClient;
import dev.lucaargolo.charta.client.gui.screens.HistoryScreen;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

public record CardPlayPayload(Component playerName, int playerCards, Component play) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CardPlayPayload> TYPE = new CustomPacketPayload.Type(Charta.id("card_play"));
    public static StreamCodec<ByteBuf, CardPlayPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.TRUSTED_CONTEXT_FREE_STREAM_CODEC, CardPlayPayload::playerName, (StreamCodec)ByteBufCodecs.INT, CardPlayPayload::playerCards, (StreamCodec)ComponentSerialization.TRUSTED_CONTEXT_FREE_STREAM_CODEC, CardPlayPayload::play, CardPlayPayload::new);

    public static void handleClient(CardPlayPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> CardPlayPayload.addToHistory(payload.playerName, payload.playerCards, payload.play));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addToHistory(Component playerName, int playerCards, Component play) {
        ChartaClient.LOCAL_HISTORY.add((Triple<Component, Integer, Component>)ImmutableTriple.of((Object)playerName, (Object)playerCards, (Object)play));
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        if (screen instanceof HistoryScreen) {
            HistoryScreen screen2 = (HistoryScreen)screen;
            screen2.init(mc, mc.getWindow().getGuiScaledWidth(), mc.getWindow().getGuiScaledHeight());
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

