/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.network;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.menu.CardSlot;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record CardContainerSlotClickPayload(int containerId, int slotId, int cardId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CardContainerSlotClickPayload> TYPE = new CustomPacketPayload.Type(Charta.id("card_container_slot_click"));
    public static final StreamCodec<ByteBuf, CardContainerSlotClickPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CardContainerSlotClickPayload::containerId, (StreamCodec)ByteBufCodecs.INT, CardContainerSlotClickPayload::slotId, (StreamCodec)ByteBufCodecs.INT, CardContainerSlotClickPayload::cardId, CardContainerSlotClickPayload::new);

    public static void handleServer(CardContainerSlotClickPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player instanceof LivingEntityMixed) {
                LivingEntityMixed mixed = (LivingEntityMixed)player;
                AbstractContainerMenu patt0$temp = player.containerMenu;
                if (patt0$temp instanceof AbstractCardMenu) {
                    AbstractCardMenu cardMenu = (AbstractCardMenu)patt0$temp;
                    if (cardMenu.containerId == payload.containerId) {
                        CardPlayer cardPlayer = mixed.charta_getCardPlayer();
                        CardSlot slot = cardMenu.getCardSlot(payload.slotId);
                        GameSlot carriedCards = cardMenu.getCarriedCards();
                        if (carriedCards.isEmpty() && slot.canRemoveCard(cardPlayer, payload.cardId)) {
                            slot.preUpdate();
                            List<Card> cards = slot.removeCards(payload.cardId);
                            cardMenu.setCarriedCards(new GameSlot(cards));
                            slot.onRemove(cardPlayer, cards, payload.cardId);
                            slot.postUpdate();
                        } else if (!carriedCards.isEmpty() && slot.canInsertCard(cardPlayer, carriedCards.stream().toList(), payload.cardId) && slot.insertCards(carriedCards, payload.cardId)) {
                            slot.preUpdate();
                            cardMenu.setCarriedCards(new GameSlot());
                            slot.onInsert(cardPlayer, carriedCards.stream().toList(), payload.cardId);
                            slot.postUpdate();
                        }
                    }
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

