/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.mixin;

import com.mojang.authlib.GameProfile;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardPlay;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player
implements LivingEntityMixed {
    @Unique
    private final LinkedList<Card> charta_hand = new LinkedList();
    @Unique
    private CompletableFuture<CardPlay> charta_play = new CompletableFuture();
    @Unique
    private final CardPlayer charta_cardPlayer = new CardPlayer(){

        @Override
        public LinkedList<Card> hand() {
            return ServerPlayerMixin.this.charta_hand;
        }

        @Override
        public void play(CardPlay play) {
            ServerPlayerMixin.this.charta_play.complete(play);
        }

        @Override
        public void afterPlay(Consumer<CardPlay> consumer) {
            ServerPlayerMixin.this.charta_play.thenAccept(play -> {
                try {
                    consumer.accept((CardPlay)play);
                }
                catch (Exception e) {
                    Charta.LOGGER.error("Error while handling {}'s Card Play. ", (Object)this.getName().getString(), (Object)e);
                }
            });
        }

        @Override
        public void resetPlay() {
            ServerPlayerMixin.this.charta_play = new CompletableFuture();
        }

        @Override
        public void tick(CardGame<?> game) {
        }

        @Override
        public boolean shouldCompute() {
            return false;
        }

        @Override
        public void openScreen(CardGame<?> game, BlockPos pos, Deck deck) {
            ServerPlayer serverPlayer = (ServerPlayer)ServerPlayerMixin.this;
            game.openScreen(serverPlayer, serverPlayer.serverLevel(), pos, deck);
        }

        @Override
        public void sendMessage(Component message) {
            ServerPlayer serverPlayer = (ServerPlayer)ServerPlayerMixin.this;
            serverPlayer.displayClientMessage(message, false);
        }

        @Override
        public void sendTitle(Component title, @Nullable Component subtitle) {
            ServerPlayer serverPlayer = (ServerPlayer)ServerPlayerMixin.this;
            if (subtitle != null) {
                serverPlayer.connection.send((Packet)new ClientboundSetSubtitleTextPacket(subtitle));
            }
            serverPlayer.connection.send((Packet)new ClientboundSetTitleTextPacket(title));
        }

        @Override
        public Component getName() {
            ServerPlayer serverPlayer = (ServerPlayer)ServerPlayerMixin.this;
            return serverPlayer.getDisplayName();
        }

        @Override
        public DyeColor getColor() {
            return DyeColor.WHITE;
        }

        @Override
        public int getId() {
            ServerPlayer serverPlayer = (ServerPlayer)ServerPlayerMixin.this;
            return serverPlayer.getId();
        }

        @Override
        public LivingEntity getEntity() {
            return ServerPlayerMixin.this;
        }
    };

    public ServerPlayerMixin(Level level, BlockPos pos, float yRot, GameProfile gameProfile) {
        super(level, pos, yRot, gameProfile);
    }

    @Override
    public CardPlayer charta_getCardPlayer() {
        return this.charta_cardPlayer;
    }
}

