/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.mixin;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.mixed.LeashableMixed;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public abstract class MobMixin
extends LivingEntity
implements LeashableMixed {
    protected MobMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="TAIL")}, method={"<clinit>"})
    private static void init(CallbackInfo ci) {
        Charta.MOB_IRON_LEASH = SynchedEntityData.defineId(Mob.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    }

    @Inject(at={@At(value="TAIL")}, method={"defineSynchedData"})
    public void defineSynchedData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(Charta.MOB_IRON_LEASH, (Object)false);
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    public void addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        tag.putBoolean("charta_isIronLeash", this.charta_isIronLeash());
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    public void readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        this.charta_setIronLeash(tag.getBoolean("charta_isIronLeash"));
    }

    @Override
    public boolean charta_isIronLeash() {
        return (Boolean)this.entityData.get(Charta.MOB_IRON_LEASH);
    }

    @Override
    public void charta_setIronLeash(boolean value) {
        this.entityData.set(Charta.MOB_IRON_LEASH, (Object)value);
    }
}

