/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.mixin;

import dev.lucaargolo.charta.block.CardTableBlock;
import dev.lucaargolo.charta.block.GameChairBlock;
import dev.lucaargolo.charta.blockentity.ModBlockEntityTypes;
import dev.lucaargolo.charta.entity.SeatEntity;
import dev.lucaargolo.charta.game.AutoPlayer;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import dev.lucaargolo.charta.utils.CardPlayerHead;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements LivingEntityMixed {
    @Unique
    private final CardPlayer charta_cardPlayer;

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.charta_cardPlayer = new AutoPlayer(this.random.nextFloat()){

            @Override
            public Component getName() {
                LivingEntity living = (LivingEntity)LivingEntityMixin.this;
                return living.getDisplayName();
            }

            @Override
            public int getId() {
                LivingEntity living = (LivingEntity)LivingEntityMixin.this;
                return living.getId();
            }

            @Override
            public CardPlayerHead getHead() {
                LivingEntity living = (LivingEntity)LivingEntityMixin.this;
                return CardPlayerHead.get(living);
            }

            @Override
            public DyeColor getColor() {
                SeatEntity seatEntity;
                BlockState state;
                LivingEntity living = (LivingEntity)LivingEntityMixin.this;
                Entity entity = living.getVehicle();
                if (entity instanceof SeatEntity && (state = (seatEntity = (SeatEntity)entity).getBlockStateOn()).getBlock() instanceof GameChairBlock) {
                    return (DyeColor)state.getValue((Property)GameChairBlock.COLOR);
                }
                return DyeColor.WHITE;
            }

            @Override
            public LivingEntity getEntity() {
                return (LivingEntity)LivingEntityMixin.this;
            }
        };
    }

    @Override
    public CardPlayer charta_getCardPlayer() {
        return this.charta_cardPlayer;
    }

    @Inject(at={@At(value="HEAD")}, method={"stopRiding"})
    public void dismountVehicle(CallbackInfo ci) {
        Direction facing;
        BlockState tableState;
        Block block;
        BlockPos pos;
        SeatEntity seatEntity;
        Level level;
        BlockState state;
        Entity entity;
        LivingEntity living = (LivingEntity)this;
        if (!living.isRemoved() && (entity = living.getVehicle()) instanceof SeatEntity && (state = (level = (seatEntity = (SeatEntity)entity).level()).getBlockState(pos = seatEntity.getOnPos())).getBlock() instanceof GameChairBlock && (block = (tableState = level.getBlockState(pos.relative(facing = (Direction)state.getValue((Property)GameChairBlock.FACING)))).getBlock()) instanceof CardTableBlock) {
            CardTableBlock cardTableBlock = (CardTableBlock)block;
            BlockPos center = (BlockPos)cardTableBlock.getCenterAndOffset((LevelAccessor)level, pos.relative(facing)).getFirst();
            level.getBlockEntity(center, (BlockEntityType)ModBlockEntityTypes.CARD_TABLE.get()).ifPresent(blockEntity -> {
                blockEntity.playersDirty = true;
            });
        }
    }
}

