/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.mixin;

import dev.lucaargolo.charta.entity.IronLeashFenceKnotEntity;
import dev.lucaargolo.charta.mixed.LeashableMixed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LeadItem.class})
public class LeadItemMixin {
    @Inject(at={@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;")}, method={"bindPlayerMobs"}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private static void ironBindPlayerMobs(Player player, Level level, BlockPos pos, CallbackInfoReturnable<InteractionResult> cir, LeashFenceKnotEntity leashfenceknotentity, List<Leashable> list) {
        Iterator<Leashable> iterator = list.iterator();
        while (iterator.hasNext()) {
            LeashableMixed mixed;
            Leashable leashable = iterator.next();
            if (!(leashable instanceof LeashableMixed) || !(mixed = (LeashableMixed)leashable).charta_isIronLeash()) continue;
            if (leashfenceknotentity == null) {
                leashfenceknotentity = IronLeashFenceKnotEntity.getOrCreateIronKnot(level, pos);
                leashfenceknotentity.playPlacementSound();
            }
            leashable.setLeashedTo((Entity)leashfenceknotentity, true);
            iterator.remove();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"leashableInArea"}, cancellable=true)
    private static void mutableList(Level level, BlockPos pos, Predicate<Leashable> predicate, CallbackInfoReturnable<List<Leashable>> cir) {
        cir.setReturnValue(new ArrayList((Collection)cir.getReturnValue()));
    }
}

