/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.lucaargolo.charta.client.ModRenderType;
import dev.lucaargolo.charta.mixed.LeashableMixed;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class})
public class EntityRendererMixin<T extends Entity> {
    @Unique
    private Entity charta_capturedLeashable;

    @Inject(at={@At(value="HEAD")}, method={"renderLeash"})
    public <E extends Entity> void captureLeashable(T entity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, E leashHolder, CallbackInfo ci) {
        this.charta_capturedLeashable = entity;
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource;getBuffer(Lnet/minecraft/client/renderer/RenderType;)Lcom/mojang/blaze3d/vertex/VertexConsumer;"), method={"renderLeash"})
    public RenderType getIronLeash(RenderType renderType) {
        LeashableMixed mixed;
        Entity entity = this.charta_capturedLeashable;
        if (entity instanceof LeashableMixed && (mixed = (LeashableMixed)entity).charta_isIronLeash()) {
            return ModRenderType.ironLeash();
        }
        return renderType;
    }
}

