/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.menu;

import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.menu.CardSlot;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Predicate;

public class HandSlot<G extends CardGame<G>>
extends CardSlot<G> {
    protected final Function<G, GameSlot> censored = g -> g.getCensoredHand(player);
    protected final Predicate<G> shouldUpdate;

    public HandSlot(G game, Predicate<G> shouldUpdate, CardPlayer player, float x, float y) {
        super(game, g -> g.getPlayerHand(player), x, y);
        this.shouldUpdate = shouldUpdate;
    }

    public HandSlot(G game, Predicate<G> shouldUpdate, CardPlayer player, float x, float y, CardSlot.Type type) {
        super(game, (G g) -> g.getPlayerHand(player), x, y, type);
        this.shouldUpdate = shouldUpdate;
    }

    public final GameSlot getCensoredSlot() {
        return this.censored.apply(this.game);
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        if (this.shouldUpdate.test(this.game)) {
            GameSlot censored = this.getCensoredSlot();
            Iterable<Card> cards = this.getSlot().getCards();
            ArrayList<Card> censoredCards = new ArrayList<Card>();
            cards.forEach(c -> censoredCards.add(Card.BLANK));
            censored.setCards(censoredCards);
        }
    }
}

