/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.menu;

import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.GameSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class CardSlot<G extends CardGame<G>> {
    public int index = -1;
    protected final G game;
    protected final Function<G, GameSlot> getter;
    public final float x;
    public final float y;
    private final Type type;

    public CardSlot(G game, Function<G, GameSlot> getter, float x, float y) {
        this(game, getter, x, y, Type.DEFAULT);
    }

    public CardSlot(G game, Function<G, GameSlot> getter, float x, float y, Type type) {
        this.game = game;
        this.x = x;
        this.y = y;
        this.getter = getter;
        this.type = type;
    }

    public final GameSlot getSlot() {
        return this.getter.apply(this.game);
    }

    public final void setCards(List<Card> cards) {
        GameSlot slot = this.getSlot();
        slot.clear();
        slot.addAll(cards);
    }

    public final boolean insertCards(GameSlot collection, int index) {
        GameSlot slot = this.getSlot();
        return index == -1 ? slot.addAll(collection) : slot.addAll(!slot.isEmpty() ? (index + 1) % (slot.size() + 1) : 0, collection);
    }

    public final List<Card> removeCards(int index) {
        GameSlot slot = this.getSlot();
        if (slot.removeAll()) {
            if (index == -1) {
                List<Card> cards = slot.stream().toList();
                slot.clear();
                return cards;
            }
            int i = !slot.isEmpty() ? index % slot.size() : 0;
            ArrayList<Card> cards = new ArrayList<Card>();
            while (i < slot.size()) {
                cards.add(slot.remove(i));
            }
            return cards;
        }
        Card card = index == -1 ? slot.removeLast() : slot.remove(!slot.isEmpty() ? index % slot.size() : 0);
        return List.of(card);
    }

    public void preUpdate() {
        ((CardGame)this.game).preUpdate();
    }

    public final void onInsert(CardPlayer player, List<Card> cards, int index) {
        this.getSlot().onInsert(player, cards, index);
    }

    public final void onRemove(CardPlayer player, List<Card> cards, int index) {
        this.getSlot().onRemove(player, cards, index);
    }

    public void postUpdate() {
        ((CardGame)this.game).postUpdate();
    }

    public final boolean canInsertCard(CardPlayer player, List<Card> cards, int index) {
        return ((CardGame)this.game).isGameReady() && !((CardGame)this.game).isGameOver() && this.getSlot().canInsertCard(player, cards, index);
    }

    public final boolean canRemoveCard(CardPlayer player, int index) {
        return ((CardGame)this.game).isGameReady() && !((CardGame)this.game).isGameOver() && this.getSlot().canRemoveCard(player, index);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isExtended() {
        return this.type == Type.PREVIEW || this.type == Type.HORIZONTAL || this.type == Type.VERTICAL;
    }

    public boolean isSmall() {
        return this.type == Type.SMALL || this.type == Type.PREVIEW;
    }

    public static float getWidth(Type type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 4 -> 37.5f;
            case 3 -> 150.0f;
            case 1 -> 12.5f;
            case 2 -> 41.0f;
        };
    }

    public static float getWidth(CardSlot<?> slot) {
        return CardSlot.getWidth(slot.getType());
    }

    public static float getHeight(Type type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 3 -> 52.5f;
            case 1, 2 -> 17.5f;
            case 4 -> 112.5f;
        };
    }

    public static float getHeight(CardSlot<?> slot) {
        return CardSlot.getHeight(slot.getType());
    }

    public static enum Type {
        DEFAULT,
        SMALL,
        PREVIEW,
        HORIZONTAL,
        VERTICAL;

    }
}

