/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.menu;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardGames;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.menu.CardSlot;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import dev.lucaargolo.charta.utils.CardContainerListener;
import dev.lucaargolo.charta.utils.CardContainerSynchronizer;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCardMenu<G extends CardGame<G>>
extends AbstractContainerMenu {
    protected final G game;
    public final NonNullList<CardSlot<G>> cardSlots = NonNullList.create();
    private final NonNullList<GameSlot> lastCardSlots = NonNullList.create();
    private final NonNullList<GameSlot> remoteCardSlots = NonNullList.create();
    private GameSlot carriedCards = new GameSlot();
    private GameSlot remoteCarriedCards = new GameSlot();
    protected final Inventory inventory;
    protected final ContainerLevelAccess access;
    protected final Deck deck;
    protected final Player player;
    protected final CardPlayer cardPlayer;
    private int currentPlayer = 0;
    private int gameReady = 0;
    private final ContainerData data = new ContainerData(){

        public int get(int index) {
            Object game = AbstractCardMenu.this.getGame();
            return switch (index) {
                case 0 -> {
                    if (((CardGame)game).getCurrentPlayer() == AbstractCardMenu.this.cardPlayer) {
                        yield 1;
                    }
                    yield AbstractCardMenu.this.currentPlayer;
                }
                case 1 -> ((CardGame)game).getPlayers().indexOf(((CardGame)game).getCurrentPlayer());
                case 2 -> {
                    if (((CardGame)game).isGameReady()) {
                        yield 1;
                    }
                    yield AbstractCardMenu.this.gameReady;
                }
                default -> throw new IllegalStateException("Unexpected value: " + index);
            };
        }

        public void set(int index, int value) {
            Object game = AbstractCardMenu.this.getGame();
            switch (index) {
                case 0: {
                    AbstractCardMenu.this.currentPlayer = value;
                    break;
                }
                case 1: {
                    ((CardGame)game).setCurrentPlayer(value);
                    break;
                }
                case 2: {
                    AbstractCardMenu.this.gameReady = value;
                }
            }
        }

        public int getCount() {
            return 3;
        }
    };

    public AbstractCardMenu(MenuType<?> menuType, int containerId, Inventory inventory, ContainerLevelAccess access, Deck deck, int[] players, byte[] options) {
        super(menuType, containerId);
        this.game = CardGames.getGameForMenu(this.getGameFactory(), access, deck, players, options);
        this.inventory = inventory;
        this.player = inventory.player;
        this.access = access;
        this.deck = deck;
        this.cardPlayer = ((LivingEntityMixed)this.player).charta_getCardPlayer();
        this.addDataSlots(this.data);
    }

    public void addTopPreview(int[] players) {
        float totalWidth = CardSlot.getWidth(CardSlot.Type.PREVIEW) + 28.0f;
        float playersWidth = (float)players.length * totalWidth + ((float)players.length - 1.0f) * (totalWidth / 10.0f);
        for (int i = 0; i < players.length; ++i) {
            G game = this.getGame();
            CardPlayer p = ((CardGame)game).getPlayers().get(i);
            this.addCardSlot(new CardSlot<CardGame>((CardGame)game, g -> g.getCensoredHand(this.cardPlayer, p), 26.0f + (70.0f - playersWidth / 2.0f) + (float)i * (totalWidth + totalWidth / 10.0f), 7.0f, CardSlot.Type.PREVIEW));
        }
    }

    public CardPlayer getCardPlayer() {
        return this.cardPlayer;
    }

    public boolean isCurrentPlayer() {
        return this.data.get(0) == 1;
    }

    public CardPlayer getCurrentPlayer() {
        return ((CardGame)this.getGame()).getPlayers().get(this.data.get(1));
    }

    public boolean isGameReady() {
        return this.data.get(2) == 1;
    }

    public Deck getDeck() {
        return this.deck;
    }

    public abstract CardGames.Factory<G> getGameFactory();

    public G getGame() {
        return this.game;
    }

    public GameSlot getCarriedCards() {
        return this.carriedCards;
    }

    public GameSlot getRemoteCarriedCards() {
        return this.remoteCarriedCards;
    }

    public void setCarriedCards(GameSlot cards) {
        this.carriedCards = cards;
    }

    public void setCarriedCards(int stateId, GameSlot cards) {
        this.carriedCards = cards;
        this.stateId = stateId;
    }

    public void setCards(int slotId, int stateId, List<Card> cards) {
        ((CardSlot)this.cardSlots.get(slotId)).setCards(cards);
        this.stateId = stateId;
    }

    public GameSlot getRemoteCards(int slotId) {
        return (GameSlot)this.remoteCardSlots.get(slotId);
    }

    protected <C extends CardSlot<G>> void addCardSlot(C slot) {
        slot.index = this.cardSlots.size();
        this.cardSlots.add(slot);
        this.lastCardSlots.add((Object)new GameSlot());
        this.remoteCardSlots.add((Object)new GameSlot());
    }

    public CardSlot<G> getCardSlot(int slotId) {
        return (CardSlot)this.cardSlots.get(slotId);
    }

    private void synchronizeCardSlotToRemote(int slotIndex, GameSlot cards, java.util.function.Supplier<GameSlot> supplier) {
        GameSlot remoteCards;
        if (!this.suppressRemoteUpdates && !(remoteCards = (GameSlot)this.remoteCardSlots.get(slotIndex)).equals(cards)) {
            GameSlot suppliedCards = supplier.get();
            this.remoteCardSlots.set(slotIndex, (Object)suppliedCards);
            ContainerSynchronizer containerSynchronizer = this.synchronizer;
            if (containerSynchronizer instanceof CardContainerSynchronizer) {
                CardContainerSynchronizer cardContainerSynchronizer = (CardContainerSynchronizer)containerSynchronizer;
                cardContainerSynchronizer.sendCardSlotChange(this, slotIndex, suppliedCards);
            }
        }
    }

    private void synchronizeCarriedCardsToRemote() {
        if (!this.suppressRemoteUpdates && !this.remoteCarriedCards.equals(this.carriedCards)) {
            this.remoteCarriedCards = GameSlot.copyOf(this.carriedCards);
            ContainerSynchronizer containerSynchronizer = this.synchronizer;
            if (containerSynchronizer instanceof CardContainerSynchronizer) {
                CardContainerSynchronizer cardContainerSynchronizer = (CardContainerSynchronizer)containerSynchronizer;
                cardContainerSynchronizer.sendCarriedCardsChange(this, this.remoteCarriedCards);
            }
        }
    }

    public void broadcastChanges() {
        for (int i = 0; i < this.cardSlots.size(); ++i) {
            GameSlot cards = ((CardSlot)this.cardSlots.get(i)).getSlot();
            Supplier cardsSupplier = Suppliers.memoize(() -> GameSlot.copyOf(cards));
            this.triggerCardSlotListeners(i, cards, (java.util.function.Supplier<GameSlot>)cardsSupplier);
            this.synchronizeCardSlotToRemote(i, cards, (java.util.function.Supplier<GameSlot>)cardsSupplier);
        }
        this.synchronizeCarriedCardsToRemote();
        super.broadcastChanges();
    }

    public void broadcastFullState() {
        for (int i = 0; i < this.cardSlots.size(); ++i) {
            GameSlot cards = ((CardSlot)this.cardSlots.get(i)).getSlot();
            this.triggerCardSlotListeners(i, cards, () -> GameSlot.copyOf(cards));
        }
        super.broadcastFullState();
    }

    private void triggerCardSlotListeners(int slotIndex, GameSlot cards, java.util.function.Supplier<GameSlot> supplier) {
        GameSlot lastCards = (GameSlot)this.lastCardSlots.get(slotIndex);
        if (!lastCards.equals(cards)) {
            GameSlot suppliedCards = supplier.get();
            this.lastCardSlots.set(slotIndex, (Object)suppliedCards);
            for (ContainerListener containerlistener : this.containerListeners) {
                if (!(containerlistener instanceof CardContainerListener)) continue;
                CardContainerListener cardContainerListener = (CardContainerListener)containerlistener;
                cardContainerListener.cardChanged(this, slotIndex, suppliedCards);
            }
        }
    }

    public void sendAllDataToRemote() {
        int j = this.cardSlots.size();
        for (int i = 0; i < j; ++i) {
            this.remoteCardSlots.set(i, (Object)GameSlot.copyOf(((CardSlot)this.cardSlots.get(i)).getSlot()));
        }
        this.remoteCarriedCards = GameSlot.copyOf(this.carriedCards);
        super.sendAllDataToRemote();
    }

    public void transferState(@NotNull AbstractContainerMenu menu) {
        super.transferState(menu);
        if (menu instanceof AbstractCardMenu) {
            AbstractCardMenu cardMenu = (AbstractCardMenu)menu;
            for (int j = 0; j < this.cardSlots.size(); ++j) {
                this.lastCardSlots.set(j, (Object)((GameSlot)cardMenu.lastCardSlots.get(j)));
                this.remoteCardSlots.set(j, (Object)((GameSlot)cardMenu.remoteCardSlots.get(j)));
            }
        }
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        GameSlot carriedCards = this.getCarriedCards();
        if (!carriedCards.isEmpty()) {
            for (Card carriedCard : carriedCards.getCards()) {
                ((CardGame)this.getGame()).getPlayerHand(this.cardPlayer).add(carriedCard);
                ((CardGame)this.getGame()).getCensoredHand(this.cardPlayer).add(Card.BLANK);
            }
            this.setCarriedCards(new GameSlot());
        }
    }
}

