/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.item;

import dev.lucaargolo.charta.block.BeerGlassBlock;
import dev.lucaargolo.charta.block.ModBlocks;
import dev.lucaargolo.charta.block.WineGlassBlock;
import dev.lucaargolo.charta.item.DeckItem;
import dev.lucaargolo.charta.item.DrinkGlassBlockItem;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"charta");
    public static final DeferredHolder<Item, DeckItem> DECK;
    public static final DeferredHolder<Item, LeadItem> IRON_LEAD;

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
    }

    static {
        ModBlocks.BLOCKS.getEntries().forEach(holder -> {
            ResourceKey resourceKey = holder.getKey();
            if (resourceKey != null) {
                String path = resourceKey.location().getPath();
                if (!path.contains("empty")) {
                    if (path.contains("wine_glass")) {
                        ITEMS.register(resourceKey.location().getPath(), () -> new DrinkGlassBlockItem((Block)holder.get(), (Block)ModBlocks.EMPTY_WINE_GLASS.get(), new Item.Properties().food(WineGlassBlock.FOOD)));
                    } else if (path.contains("beer_glass")) {
                        ITEMS.register(resourceKey.location().getPath(), () -> new DrinkGlassBlockItem((Block)holder.get(), (Block)ModBlocks.EMPTY_BEER_GLASS.get(), new Item.Properties().food(BeerGlassBlock.FOOD)));
                    } else {
                        ITEMS.register(resourceKey.location().getPath(), () -> new BlockItem((Block)holder.get(), new Item.Properties()));
                    }
                } else {
                    ITEMS.register(resourceKey.location().getPath(), () -> new BlockItem((Block)holder.get(), new Item.Properties()));
                }
            }
        });
        DECK = ITEMS.register("deck", () -> new DeckItem(new Item.Properties().stacksTo(1)));
        IRON_LEAD = ITEMS.register("iron_lead", () -> new LeadItem(new Item.Properties()));
    }
}

