/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.item;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.gui.screens.DeckScreen;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.item.ModDataComponentTypes;
import dev.lucaargolo.charta.item.ModItems;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeckItem
extends Item {
    public DeckItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        Deck deck = DeckItem.getDeck(stack);
        return deck != null ? deck.getName() : super.getName(stack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Deck deck;
        ItemStack stack = player.getItemInHand(usedHand);
        if (level.isClientSide() && (deck = DeckItem.getDeck(stack)) != null) {
            DeckItem.openScreen(deck);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openScreen(Deck deck) {
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.setScreen((Screen)new DeckScreen(null, deck));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        Deck deck = DeckItem.getDeck(stack);
        if (deck != null) {
            tooltipComponents.add((Component)Component.literal((String)String.valueOf(deck.getCards().size())).append(" ").append((Component)Component.translatable((String)"charta.cards")).withStyle(ChatFormatting.DARK_PURPLE));
        }
    }

    @Nullable
    public static Deck getDeck(ItemStack stack) {
        ResourceLocation deckId = (ResourceLocation)stack.get(ModDataComponentTypes.CARD_DECK);
        return deckId != null ? Charta.CARD_DECKS.getDeck(deckId) : null;
    }

    public static ItemStack getDeck(Deck deck) {
        ResourceLocation deckId = Charta.CARD_DECKS.getDecks().entrySet().stream().filter(e -> e.getValue() == deck).map(Map.Entry::getKey).findFirst().orElse(Charta.id("missing"));
        return DeckItem.getDeck(deckId);
    }

    public static ItemStack getDeck(ResourceLocation deckId) {
        Deck deck = Charta.CARD_DECKS.getDeck(deckId);
        ItemStack stack = ((DeckItem)((Object)ModItems.DECK.get())).getDefaultInstance();
        stack.set(ModDataComponentTypes.CARD_DECK, (Object)deckId);
        stack.set(DataComponents.RARITY, (Object)deck.getRarity());
        return stack;
    }
}

