/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game.solitaire;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import dev.lucaargolo.charta.client.gui.screens.GameScreen;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.game.Suit;
import dev.lucaargolo.charta.game.solitaire.SolitaireGame;
import dev.lucaargolo.charta.game.solitaire.SolitaireMenu;
import dev.lucaargolo.charta.menu.CardSlot;
import dev.lucaargolo.charta.network.RestoreSolitairePayload;
import dev.lucaargolo.charta.utils.ChartaGuiGraphics;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class SolitaireScreen
extends GameScreen<SolitaireGame, SolitaireMenu> {
    private Component hint;
    private int hintTime = 0;
    private int lastMoves = 0;

    public SolitaireScreen(SolitaireMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.imageWidth = 302;
        this.imageHeight = 180;
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int moves;
        int i = 0;
        for (Suit suit : List.of(Suit.SPADES, Suit.HEARTS, Suit.CLUBS, Suit.DIAMONDS)) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((double)this.leftPos + 140.5 + (double)i * 42.5, (double)(this.topPos + 22), 0.0);
            guiGraphics.pose().translate(0.5f, 0.0f, 0.0f);
            guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
            ChartaGuiGraphics.blitWhiteSuitAndGlow(guiGraphics, this.getDeck(), suit, 0.0f, 0.0f, 0.0f, 0.0f, 13.0f, 13.0f, 13.0f, 13.0f);
            RenderSystem.defaultBlendFunc();
            guiGraphics.pose().popPose();
            ++i;
        }
        MutableComponent text = Component.literal((String)"Solitaire");
        guiGraphics.drawString(this.font, (Component)text, this.width / 2 - this.font.width((FormattedText)text) / 2, 14, -1);
        int x = (this.width / 2 - (int)CardSlot.getWidth(CardSlot.Type.HORIZONTAL) / 2) / 2 - 32;
        int y = this.height - 9 - 14;
        int color = 2988543;
        boolean canRestore = ((SolitaireMenu)this.menu).canRestore() && ((SolitaireMenu)this.menu).getCarriedCards().isEmpty();
        guiGraphics.fill(x + 1, y + 1, x + 63, y + 16, -16777216 + (canRestore ? color : 0x666666));
        Vec3 c = Vec3.fromRGB24((int)color);
        RenderSystem.setShaderColor((float)((float)c.x), (float)((float)c.y), (float)((float)c.z), (float)1.0f);
        guiGraphics.blit(WIDGETS, x, y, 59, 0, 65, 18);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        text = Component.literal((String)"Undo");
        guiGraphics.drawString(this.font, (Component)text, x + 32 - this.font.width((FormattedText)text) / 2, y + 5, -1);
        if (mouseX >= x && mouseX < x + 65 && mouseY >= y && mouseY < y + 18) {
            guiGraphics.fill(x + 1, y + 1, x + 63, y + 16, 0x33FFFFFF);
            this.scheduleTooltip((Component)Component.translatable((String)"message.charta.undo"));
        }
        if ((moves = ((SolitaireMenu)this.menu).getMoves()) != this.lastMoves) {
            this.hintTime = 0;
            this.hint = null;
            for (GameSlot slot : ((SolitaireGame)((SolitaireMenu)this.menu).getGame()).getSlots()) {
                slot.highlightTime = 0;
            }
        }
        this.lastMoves = moves;
        if (this.hint != null && this.hintTime > 0) {
            text = this.hint;
            List list = this.font.split((FormattedText)text, 180);
            if (list.size() == 1) {
                guiGraphics.drawString(this.font, (Component)text, this.width / 2 - this.font.width((FormattedText)text) / 2, this.height - 18, -1);
            } else {
                for (i = 0; i < list.size(); ++i) {
                    guiGraphics.drawString(this.font, (FormattedCharSequence)list.get(i), this.width / 2 - this.font.width((FormattedCharSequence)list.get(i)) / 2, this.height - 23 + 10 * i, -1);
                }
            }
        } else {
            Object minutes;
            text = Component.translatable((String)"message.charta.moves", (Object[])new Object[]{moves});
            guiGraphics.drawString(this.font, (Component)text, this.width / 2 - this.font.width((FormattedText)text) / 2, this.height - 23, -1);
            int time = ((SolitaireMenu)this.menu).getTime();
            Object seconds = String.valueOf(time % 60);
            if (((String)seconds).length() == 1) {
                seconds = "0" + (String)seconds;
            }
            if (((String)(minutes = String.valueOf(time / 60))).length() == 1) {
                minutes = "0" + (String)minutes;
            }
            text = Component.literal((String)((String)minutes + ":" + (String)seconds));
            guiGraphics.drawString(this.font, (Component)text, this.width / 2 - this.font.width((FormattedText)text) / 2, this.height - 13, -1);
        }
        guiGraphics.fill((x += this.width / 2 + (int)CardSlot.getWidth(CardSlot.Type.HORIZONTAL) / 2) + 1, y + 1, x + 63, y + 16, -16777216 + color);
        c = Vec3.fromRGB24((int)color);
        RenderSystem.setShaderColor((float)((float)c.x), (float)((float)c.y), (float)((float)c.z), (float)1.0f);
        guiGraphics.blit(WIDGETS, x, y, 59, 0, 65, 18);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        text = Component.literal((String)"Hint");
        guiGraphics.drawString(this.font, (Component)text, x + 32 - this.font.width((FormattedText)text) / 2, y + 5, -1);
        if (mouseX >= x && mouseX < x + 65 && mouseY >= y && mouseY < y + 18) {
            guiGraphics.fill(x + 1, y + 1, x + 63, y + 16, 0x33FFFFFF);
            this.scheduleTooltip((Component)Component.translatable((String)"message.charta.hint"));
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int x = (this.width / 2 - (int)CardSlot.getWidth(CardSlot.Type.HORIZONTAL) / 2) / 2 - 32;
        int y = this.height - 9 - 14;
        if (mouseX >= (double)x && mouseX < (double)(x + 65) && mouseY >= (double)y && mouseY < (double)(y + 18)) {
            boolean canRestore;
            boolean bl = canRestore = ((SolitaireMenu)this.menu).canRestore() && ((SolitaireMenu)this.menu).getCarriedCards().isEmpty();
            if (canRestore) {
                PacketDistributor.sendToServer((CustomPacketPayload)new RestoreSolitairePayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        if (mouseX >= (double)(x += this.width / 2 + (int)CardSlot.getWidth(CardSlot.Type.HORIZONTAL) / 2) && mouseX < (double)(x + 65) && mouseY >= (double)y && mouseY < (double)(y + 18)) {
            Pair<Component, List<GameSlot>> hint = ((SolitaireGame)((SolitaireMenu)this.menu).getGame()).getHint();
            this.hint = (Component)hint.getFirst();
            this.hintTime = 100;
            for (GameSlot slot : (List)hint.getSecond()) {
                slot.highlightTime = this.hintTime;
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void containerTick() {
        super.containerTick();
        if (this.hintTime > 0) {
            --this.hintTime;
        } else {
            this.hint = null;
        }
    }

    @Override
    public void renderTopBar(@NotNull GuiGraphics guiGraphics) {
        guiGraphics.fill(0, 0, this.width, 28, -2013265920);
    }

    @Override
    public void renderBottomBar(@NotNull GuiGraphics guiGraphics) {
        guiGraphics.fill(0, this.height - 28, this.width, this.height, -2013265920);
    }
}

