/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game.solitaire;

import dev.lucaargolo.charta.game.CardGames;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.game.solitaire.SolitaireGame;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.menu.CardSlot;
import dev.lucaargolo.charta.menu.ModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SolitaireMenu
extends AbstractCardMenu<SolitaireGame> {
    private int canRestore = 0;
    private final ContainerData data = new ContainerData(){

        public int get(int i) {
            return switch (i) {
                case 0 -> ((SolitaireGame)((SolitaireMenu)SolitaireMenu.this).game).moves;
                case 1 -> ((SolitaireGame)((SolitaireMenu)SolitaireMenu.this).game).time;
                case 2 -> {
                    if (((SolitaireGame)SolitaireMenu.this.game).canRestore()) {
                        yield 1;
                    }
                    yield SolitaireMenu.this.canRestore;
                }
                default -> 0;
            };
        }

        public void set(int i, int value) {
            switch (i) {
                case 0: {
                    ((SolitaireGame)((SolitaireMenu)SolitaireMenu.this).game).moves = value;
                    break;
                }
                case 1: {
                    ((SolitaireGame)((SolitaireMenu)SolitaireMenu.this).game).time = value;
                    break;
                }
                case 2: {
                    SolitaireMenu.this.canRestore = value;
                }
            }
        }

        public int getCount() {
            return 3;
        }
    };

    public SolitaireMenu(int containerId, Inventory inventory, RegistryFriendlyByteBuf buf) {
        this(containerId, inventory, ContainerLevelAccess.create((Level)inventory.player.level(), (BlockPos)buf.readBlockPos()), (Deck)Deck.STREAM_CODEC.decode((Object)buf), buf.readVarIntArray(), buf.readByteArray());
    }

    public SolitaireMenu(int containerId, Inventory inventory, ContainerLevelAccess access, Deck deck, int[] players, byte[] options) {
        super((MenuType)ModMenus.SOLITAIRE.get(), containerId, inventory, access, deck, players, options);
        int s;
        int i;
        GameSlot playerHand = ((SolitaireGame)this.game).getPlayerHand(this.cardPlayer);
        if (!playerHand.isEmpty()) {
            this.getCarriedCards().addAll(playerHand);
            ((SolitaireGame)this.game).getPlayerHand(this.cardPlayer).clear();
            ((SolitaireGame)this.game).getCensoredHand(this.cardPlayer).clear();
        }
        this.addCardSlot(new CardSlot<SolitaireGame>((SolitaireGame)this.game, g -> g.getSlot(0), 5.0f, 5.0f));
        this.addCardSlot(new CardSlot<SolitaireGame>((SolitaireGame)this.game, g -> g.getSlot(1), 47.5f, 5.0f));
        for (i = 0; i < 4; ++i) {
            s = 2 + i;
            this.addCardSlot(new CardSlot<SolitaireGame>((SolitaireGame)this.game, g -> g.getSlot(s), 5.0f + 42.5f * (float)(3 + i), 5.0f));
        }
        for (i = 0; i < 7; ++i) {
            s = 6 + i;
            this.addCardSlot(new CardSlot<SolitaireGame>((SolitaireGame)this.game, g -> g.getSlot(s), 5.0f + 42.5f * (float)i, 62.5f, CardSlot.Type.VERTICAL));
        }
        this.addDataSlots(this.data);
    }

    public int getMoves() {
        return this.data.get(0);
    }

    public int getTime() {
        return this.data.get(1);
    }

    public boolean canRestore() {
        return this.canRestore > 0;
    }

    @Override
    public CardGames.Factory<SolitaireGame> getGameFactory() {
        return CardGames.SOLITAIRE;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@NotNull Player player) {
        return this.game != null && this.cardPlayer != null && !((SolitaireGame)this.game).isGameOver();
    }
}

