/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game.solitaire;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardPlay;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.game.GameOption;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.game.Rank;
import dev.lucaargolo.charta.game.Suit;
import dev.lucaargolo.charta.game.solitaire.SolitaireMenu;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.sound.ModSounds;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SolitaireGame
extends CardGame<SolitaireGame> {
    private final List<Snapshot> snapshots = new ArrayList<Snapshot>();
    private final GameSlot stockPile;
    private final GameSlot wastePile;
    private final Map<Suit, GameSlot> foundationPiles;
    private final List<GameSlot> tableauPiles;
    @Nullable
    private Card lastStockCard = null;
    private int lastTableauDraw = -1;
    private int age = 0;
    private boolean taken = false;
    public int moves = 0;
    public int time = 0;

    public SolitaireGame(List<CardPlayer> players, Deck deck) {
        super(players, deck);
        GameSlot slot;
        float middleX = 80.0f;
        float leftX = middleX - 12.5f - 90.0f;
        float middleY = 80.0f;
        float topY = middleY + 61.25f;
        this.stockPile = this.addSlot(new GameSlot(new LinkedList(), leftX, topY, 0.0f, 0.0f){

            @Override
            public boolean canInsertCard(CardPlayer player, List<Card> cards, int index) {
                return false;
            }

            @Override
            public void onRemove(CardPlayer player, List<Card> cards, int index) {
                super.onRemove(player, cards, index);
                SolitaireGame.this.lastStockCard = cards.getLast();
                SolitaireGame.this.lastStockCard.flip();
            }

            @Override
            public boolean removeAll() {
                return false;
            }
        });
        this.stockPile.highlightColor = 15831804;
        this.wastePile = this.addSlot(new GameSlot(new LinkedList(), leftX + 25.0f + 5.0f, topY, 0.0f, 0.0f){

            @Override
            public boolean canInsertCard(CardPlayer player, List<Card> cards, int index) {
                return cards.size() == 1 && cards.getLast() == SolitaireGame.this.lastStockCard;
            }

            @Override
            public void onInsert(CardPlayer player, List<Card> cards, int index) {
                super.onInsert(player, cards, index);
                SolitaireGame.this.lastStockCard = null;
                player.play(null);
            }

            @Override
            public void onRemove(CardPlayer player, List<Card> cards, int index) {
                super.onRemove(player, cards, index);
                SolitaireGame.this.lastStockCard = cards.getLast();
            }

            @Override
            public boolean removeAll() {
                return false;
            }
        });
        this.wastePile.highlightColor = 16539741;
        int i = 0;
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (final Suit suit : List.of(Suit.SPADES, Suit.HEARTS, Suit.CLUBS, Suit.DIAMONDS)) {
            slot = this.addSlot(new GameSlot(new LinkedList(), leftX + (float)(30 * (3 + i++)), topY, 0.0f, 0.0f){

                @Override
                public boolean canRemoveCard(CardPlayer player, int index) {
                    return index == this.size() - 1 || index == -1;
                }

                @Override
                public boolean canInsertCard(CardPlayer player, List<Card> cards, int index) {
                    if (index != -1 && index != this.size()) {
                        return false;
                    }
                    int i = this.isEmpty() ? 0 : this.getLast().rank().ordinal();
                    for (Card card : cards) {
                        if (card.suit() == suit && card.rank().ordinal() == 1 + i++) continue;
                        return false;
                    }
                    return true;
                }

                @Override
                public void onInsert(CardPlayer player, List<Card> cards, int index) {
                    super.onInsert(player, cards, index);
                    SolitaireGame.this.lastStockCard = null;
                    if (SolitaireGame.this.lastTableauDraw >= 0) {
                        player.play(cards, SolitaireGame.this.lastTableauDraw);
                    } else {
                        player.play(null);
                    }
                    SolitaireGame.this.lastTableauDraw = -1;
                }

                @Override
                public boolean removeAll() {
                    return false;
                }
            });
            slot.highlightColor = 9699228;
            map.put((Object)suit, (Object)slot);
        }
        this.foundationPiles = map.build();
        ImmutableList.Builder list = ImmutableList.builder();
        for (i = 0; i < 7; ++i) {
            final int s = 6 + i;
            slot = this.addSlot(new GameSlot(new LinkedList(), leftX + 25.0f + (float)(30 * i), topY + 5.0f + 35.0f - 52.5f, 0.0f, 180.0f, Direction.NORTH, 105.0f, false){

                @Override
                public boolean canRemoveCard(CardPlayer player, int index) {
                    if (index == -1) {
                        return this.size() == 1;
                    }
                    Card last = null;
                    for (int i = index; i < this.size(); ++i) {
                        Card current = this.get(i);
                        if (last != null && (last.flipped() || !SolitaireGame.isAlternate(last, current))) {
                            return false;
                        }
                        last = current;
                    }
                    return true;
                }

                @Override
                public void onRemove(CardPlayer player, List<Card> cards, int index) {
                    super.onRemove(player, cards, index);
                    SolitaireGame.this.lastTableauDraw = s;
                }

                @Override
                public boolean canInsertCard(CardPlayer player, List<Card> cards, int index) {
                    if (index != -1 && index != this.size() - 1) {
                        return false;
                    }
                    if (SolitaireGame.this.lastTableauDraw == s) {
                        return true;
                    }
                    Card last = this.isEmpty() ? null : this.getLast();
                    for (Card current : cards) {
                        if (last == null && current.rank() != Rank.KING || last != null && !SolitaireGame.isAlternate(last, current) || last != null && current.rank().ordinal() + 1 != last.rank().ordinal()) {
                            return false;
                        }
                        last = current;
                    }
                    return true;
                }

                @Override
                public void onInsert(CardPlayer player, List<Card> cards, int index) {
                    super.onInsert(player, cards, index);
                    SolitaireGame.this.lastStockCard = null;
                    if (SolitaireGame.this.lastTableauDraw != s && SolitaireGame.this.lastTableauDraw >= 0) {
                        player.play(cards, SolitaireGame.this.lastTableauDraw);
                    } else {
                        player.play(null);
                    }
                    SolitaireGame.this.lastTableauDraw = -1;
                }
            });
            slot.highlightColor = 16774512;
            list.add((Object)slot);
        }
        this.tableauPiles = list.build();
    }

    @Override
    public AbstractCardMenu<SolitaireGame> createMenu(int containerId, Inventory playerInventory, ServerLevel level, BlockPos pos, Deck deck) {
        return new SolitaireMenu(containerId, playerInventory, ContainerLevelAccess.create((Level)level, (BlockPos)pos), deck, this.players.stream().mapToInt(CardPlayer::getId).toArray(), this.getRawOptions());
    }

    @Override
    public Predicate<Deck> getDeckPredicate() {
        return deck -> deck.getCards().size() == 52 && Charta.DEFAULT_SUITS.containsAll((Collection<?>)deck.getUniqueSuits()) && deck.getUniqueSuits().containsAll(Charta.DEFAULT_SUITS);
    }

    @Override
    public Predicate<Card> getCardPredicate() {
        return card -> Charta.DEFAULT_SUITS.contains(card.suit()) && Charta.DEFAULT_RANKS.contains(card.rank());
    }

    @Override
    public boolean canPlay(CardPlayer player, CardPlay play) {
        return false;
    }

    @Override
    public void startGame() {
        this.stockPile.clear();
        this.wastePile.clear();
        this.foundationPiles.values().forEach(GameSlot::clear);
        this.tableauPiles.forEach(GameSlot::clear);
        this.stockPile.addAll(this.gameDeck);
        this.stockPile.shuffle();
        for (CardPlayer player : this.players) {
            player.resetPlay();
            this.getPlayerHand(player).clear();
            this.getCensoredHand(player).clear();
        }
        for (int i = 0; i < this.tableauPiles.size(); ++i) {
            for (int j = 0; j < this.tableauPiles.size(); ++j) {
                int slot = j;
                int amount = i;
                if (slot < amount) continue;
                this.scheduledActions.add(() -> {
                    this.currentPlayer.playSound((SoundEvent)ModSounds.CARD_DRAW.get());
                    Card card = this.stockPile.removeLast();
                    if (slot == amount) {
                        card.flip();
                    }
                    this.tableauPiles.get(slot).addLast(card);
                });
                this.scheduledActions.add(() -> {});
            }
        }
        this.scheduledActions.add(() -> Snapshot.create(this));
        this.currentPlayer = (CardPlayer)this.players.getFirst();
        this.isGameReady = false;
        this.isGameOver = false;
        this.table((Component)Component.translatable((String)"message.charta.game_started"));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isGameReady) {
            ++this.age;
            if (this.age % 20 == 0) {
                ++this.time;
            }
        }
    }

    @Override
    public void runGame() {
        if (!this.isGameReady) {
            return;
        }
        this.currentPlayer.afterPlay(play -> {
            this.currentPlayer.resetPlay();
            if (play != null) {
                GameSlot s = this.getSlot(play.slot());
                if (!s.isEmpty() && s.getLast().flipped()) {
                    s.getLast().flip();
                    s.setDirty(true);
                    this.play(this.currentPlayer, (Component)Component.translatable((String)"message.charta.revealed_a_card", (Object[])new Object[]{Component.translatable((String)this.deck.getCardTranslatableKey(s.getLast())), play.slot() - 5}));
                } else {
                    this.play(this.currentPlayer, (Component)Component.translatable((String)"message.charta.did_a_move"));
                }
            } else {
                this.play(this.currentPlayer, (Component)Component.translatable((String)"message.charta.did_a_move"));
            }
            if (this.stockPile.isEmpty()) {
                this.wastePile.forEach(Card::flip);
                this.wastePile.reverse();
                this.stockPile.addAll(this.wastePile);
                this.wastePile.clear();
            }
            boolean allEmpty = true;
            for (GameSlot slot : this.tableauPiles) {
                allEmpty = allEmpty && slot.isEmpty();
            }
            if (allEmpty) {
                this.endGame();
            } else {
                this.runGame();
            }
        });
    }

    @Override
    public void endGame() {
        boolean allEmpty = true;
        for (GameSlot slot : this.tableauPiles) {
            allEmpty = allEmpty && slot.isEmpty();
        }
        if (allEmpty) {
            this.currentPlayer.sendTitle((Component)Component.translatable((String)"message.charta.you_won").withStyle(ChatFormatting.GREEN), (Component)Component.translatable((String)"message.charta.congratulations"));
        } else {
            this.currentPlayer.sendTitle((Component)Component.translatable((String)"message.charta.you_lost").withStyle(ChatFormatting.RED), (Component)Component.translatable((String)"message.charta.give_up"));
        }
        this.isGameOver = true;
    }

    public boolean canRestore() {
        return this.moves > 0 && !this.snapshots.isEmpty();
    }

    public void restore() {
        if (!this.snapshots.isEmpty()) {
            this.currentPlayer.playSound((SoundEvent)ModSounds.CARD_DRAW.get());
            Snapshot snapshot = this.snapshots.removeLast();
            snapshot.restore(this);
            ++this.moves;
            this.currentPlayer.playSound((SoundEvent)ModSounds.CARD_PLAY.get());
        }
    }

    @Override
    public void preUpdate() {
        if (!this.taken) {
            Snapshot current = Snapshot.create(this);
            if (!this.snapshots.isEmpty()) {
                Snapshot last = this.snapshots.getLast();
                if (!current.equals(last)) {
                    this.snapshots.addLast(current);
                }
            } else {
                this.snapshots.addLast(current);
            }
        }
    }

    @Override
    public void postUpdate() {
        if (this.taken) {
            if (!this.snapshots.isEmpty()) {
                Snapshot last;
                Snapshot current = Snapshot.create(this);
                if (!current.equals(last = this.snapshots.getLast())) {
                    ++this.moves;
                }
            } else {
                ++this.moves;
            }
            this.taken = false;
        } else {
            this.taken = true;
        }
    }

    @Override
    public int getMinPlayers() {
        return 1;
    }

    @Override
    public int getMaxPlayers() {
        return 1;
    }

    @Override
    public List<GameOption<?>> getOptions() {
        return List.of();
    }

    public static boolean isAlternate(Card c1, Card c2) {
        boolean v1 = c1.suit() == Suit.HEARTS || c1.suit() == Suit.DIAMONDS;
        boolean v2 = c2.suit() == Suit.HEARTS || c2.suit() == Suit.DIAMONDS;
        return v1 != v2;
    }

    public Pair<Component, List<GameSlot>> getHint() {
        Object card;
        for (GameSlot slot : this.tableauPiles) {
            Card card2;
            if (slot.isEmpty() || !this.foundationPiles.get((card2 = slot.getLast()).suit()).canInsertCard(this.currentPlayer, List.of(card2), -1)) continue;
            return Pair.of((Object)Component.translatable((String)"message.charta.move_card_from_tableau_to_foundation", (Object[])new Object[]{Component.translatable((String)this.deck.getCardTranslatableKey(card2)).withColor(this.deck.getCardColor(card2))}), List.of(slot, this.foundationPiles.get(card2.suit())));
        }
        if (!this.wastePile.isEmpty() && this.foundationPiles.get(((Card)(card = this.wastePile.getLast())).suit()).canInsertCard(this.currentPlayer, List.of(card), -1)) {
            return Pair.of((Object)Component.translatable((String)"message.charta.move_card_from_waste_to_foundation", (Object[])new Object[]{Component.translatable((String)this.deck.getCardTranslatableKey((Card)card)).withColor(this.deck.getCardColor((Card)card))}), List.of(this.wastePile, this.foundationPiles.get(((Card)card).suit())));
        }
        for (GameSlot fromSlot : this.tableauPiles) {
            for (int i = 0; i < fromSlot.size(); ++i) {
                Card card3 = fromSlot.get(i);
                if (card3.flipped()) continue;
                for (GameSlot toSlot : this.tableauPiles) {
                    if (fromSlot == toSlot || !toSlot.canInsertCard(this.currentPlayer, List.of(card3), -1)) continue;
                    return Pair.of((Object)Component.translatable((String)"message.charta.move_card_from_tableau_to_tableau", (Object[])new Object[]{Component.translatable((String)this.deck.getCardTranslatableKey(card3)).withColor(this.deck.getCardColor(card3))}), List.of(fromSlot, toSlot));
                }
            }
        }
        if (!this.wastePile.isEmpty()) {
            card = this.wastePile.getLast();
            for (GameSlot slot : this.tableauPiles) {
                if (!slot.canInsertCard(this.currentPlayer, List.of(card), -1)) continue;
                return Pair.of((Object)Component.translatable((String)"message.charta.move_card_from_waste_to_tableau", (Object[])new Object[]{Component.translatable((String)this.deck.getCardTranslatableKey((Card)card)).withColor(this.deck.getCardColor((Card)card))}), List.of(this.wastePile, slot));
            }
        }
        return Pair.of((Object)Component.translatable((String)"message.charta.no_moves_available"), List.of(this.stockPile));
    }

    private record Snapshot(List<Card> stockPile, List<Card> wastePile, Map<Suit, List<Card>> foundationPiles, List<List<Card>> tableauPiles) {
        private static Snapshot create(SolitaireGame game) {
            return new Snapshot(game.stockPile.stream().map(Card::copy).collect(Collectors.toList()), game.wastePile.stream().map(Card::copy).collect(Collectors.toList()), game.foundationPiles.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((GameSlot)e.getValue()).stream().map(Card::copy).collect(Collectors.toList()))), game.tableauPiles.stream().map(g -> g.stream().map(Card::copy).collect(Collectors.toList())).toList());
        }

        private String state() {
            StringBuilder str = new StringBuilder();
            str.append(this.stockPile.size());
            str.append("-");
            this.stockPile.forEach(c -> str.append(c.toString()));
            str.append("-");
            str.append(this.wastePile.size());
            str.append("-");
            this.wastePile.forEach(c -> str.append(c.toString()));
            str.append("-");
            this.foundationPiles.forEach((suit, cards) -> {
                str.append(suit);
                str.append("-");
                str.append(cards.size());
                str.append("-");
                cards.forEach(c -> str.append(c.toString()));
                str.append("-");
            });
            for (int i = 0; i < this.tableauPiles.size(); ++i) {
                List<Card> cards2 = this.tableauPiles.get(i);
                str.append(i);
                str.append("-");
                str.append(cards2.size());
                str.append("-");
                cards2.forEach(c -> str.append(c.toString()));
                str.append("-");
            }
            return str.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Snapshot snapshot = (Snapshot)o;
            return snapshot.state().equals(this.state());
        }

        @Override
        public int hashCode() {
            return this.state().hashCode();
        }

        private void restore(SolitaireGame game) {
            game.stockPile.setCards(this.stockPile);
            game.wastePile.setCards(this.wastePile);
            game.foundationPiles.forEach((suit, slot) -> slot.setCards(this.foundationPiles.get(suit)));
            for (int i = 0; i < game.tableauPiles.size(); ++i) {
                game.tableauPiles.get(i).setCards(this.tableauPiles.get(i));
            }
        }
    }
}

