/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game.fun;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.gui.screens.GameScreen;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.Suit;
import dev.lucaargolo.charta.game.fun.FunGame;
import dev.lucaargolo.charta.game.fun.FunMenu;
import dev.lucaargolo.charta.menu.CardSlot;
import dev.lucaargolo.charta.network.CardContainerSlotClickPayload;
import dev.lucaargolo.charta.network.LastFunPayload;
import dev.lucaargolo.charta.utils.ChartaGuiGraphics;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class FunScreen
extends GameScreen<FunGame, FunMenu> {
    private int lastCooldown = 30;
    private boolean drawAll = false;
    @Nullable
    private ItemStack itemActivationItem;
    private int itemActivationTicks;
    private float itemActivationOffX;
    private float itemActivationOffY;
    private final Random random = new Random();

    public FunScreen(FunMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.imageWidth = 140;
        this.imageHeight = 180;
    }

    @Override
    public void containerTick() {
        super.containerTick();
        if (!((FunMenu)this.menu).canDoLast()) {
            this.lastCooldown = 30;
        } else if (((FunMenu)this.menu).didntSayLast()) {
            this.lastCooldown = 0;
        } else if (this.lastCooldown > 0) {
            --this.lastCooldown;
        }
        if (!((FunMenu)this.menu).isCurrentPlayer()) {
            this.drawAll = false;
        } else if (this.drawAll) {
            if (((FunMenu)this.menu).getCarriedCards().isEmpty()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new CardContainerSlotClickPayload(((FunMenu)this.menu).containerId, ((FunMenu)this.menu).cardSlots.size() - 3, -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                this.drawAll = false;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new CardContainerSlotClickPayload(((FunMenu)this.menu).containerId, ((FunMenu)this.menu).cardSlots.size() - 1, -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (this.itemActivationTicks > 0) {
            --this.itemActivationTicks;
            if (this.itemActivationTicks == 0) {
                this.itemActivationItem = null;
            }
        }
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int x = (this.width / 2 - (int)CardSlot.getWidth(CardSlot.Type.HORIZONTAL) / 2) / 2 - 32;
        int y = this.height - (int)CardSlot.getHeight(CardSlot.Type.HORIZONTAL) / 2 - 14;
        int color = ((FunMenu)this.menu).canDoLast() ? (((FunMenu)this.menu).didntSayLast() ? 65280 : 0xFF0000) : 0x333333;
        guiGraphics.fill(x + 1, y + 1, x + 63, y + 16, -16777216 + color);
        Vec3 c = Vec3.fromRGB24((int)color);
        RenderSystem.setShaderColor((float)((float)c.x), (float)((float)c.y), (float)((float)c.z), (float)1.0f);
        guiGraphics.blit(WIDGETS, x, y, 59, 0, 65, 18);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MutableComponent text = Component.literal((String)(((FunMenu)this.menu).canDoLast() && this.lastCooldown > 0 ? Integer.toString(this.lastCooldown) : "Last!")).withStyle(Charta.MINERCRAFTORY);
        guiGraphics.drawString(this.font, (Component)text, x + 32 - this.font.width((FormattedText)text) / 2, y + 7, -1);
        if (mouseX >= x && mouseX < x + 65 && mouseY >= y && mouseY < y + 18) {
            guiGraphics.fill(x + 1, y + 1, x + 63, y + 16, 0x33FFFFFF);
            this.scheduleTooltip((Component)Component.translatable((String)"message.charta.say_last"));
        }
        color = ((FunMenu)this.menu).isCurrentPlayer() && ((FunMenu)this.menu).getDrawStack() > 0 && ((FunMenu)this.menu).canDraw() ? Color.HSBtoRGB(0.333f + (float)((FunMenu)this.menu).getDrawStack() / 32.0f * 0.666f, 1.0f, 1.0f) : 0x333333;
        guiGraphics.fill((x += this.width / 2 + (int)CardSlot.getWidth(CardSlot.Type.HORIZONTAL) / 2) + 1, y + 1, x + 63, y + 16, -16777216 + color);
        c = Vec3.fromRGB24((int)color);
        RenderSystem.setShaderColor((float)((float)c.x), (float)((float)c.y), (float)((float)c.z), (float)1.0f);
        guiGraphics.blit(WIDGETS, x, y, 59, 0, 65, 18);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        text = Component.literal((String)(((FunMenu)this.menu).getDrawStack() > 0 ? "Draw " + ((FunMenu)this.menu).getDrawStack() : "Draw")).withStyle(Charta.MINERCRAFTORY);
        guiGraphics.drawString(this.font, (Component)text, x + 32 - this.font.width((FormattedText)text) / 2, y + 7, -1);
        if (mouseX >= x && mouseX < x + 65 && mouseY >= y && mouseY < y + 18) {
            guiGraphics.fill(x + 1, y + 1, x + 63, y + 16, 0x33FFFFFF);
            this.scheduleTooltip((Component)Component.translatable((String)"message.charta.draw_all_cards"));
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int x = (this.width / 2 - (int)CardSlot.getWidth(CardSlot.Type.HORIZONTAL) / 2) / 2 - 32;
        int y = this.height - (int)CardSlot.getHeight(CardSlot.Type.HORIZONTAL) / 2 - 14;
        if (mouseX >= (double)x && mouseX < (double)(x + 65) && mouseY >= (double)y && mouseY < (double)(y + 18)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new LastFunPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        if (mouseX >= (double)(x += this.width / 2 + (int)CardSlot.getWidth(CardSlot.Type.HORIZONTAL) / 2) && mouseX < (double)(x + 65) && mouseY >= (double)y && mouseY < (double)(y + 18)) {
            this.drawAll = ((FunMenu)this.menu).isCurrentPlayer() && ((FunMenu)this.menu).getCarriedCards().isEmpty();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderItemActivationAnimation(guiGraphics, partialTick);
    }

    @Override
    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        MutableComponent text = Component.literal((String)"Fun").withStyle(Charta.MINERCRAFTORY);
        guiGraphics.drawString(this.font, (Component)text, this.imageWidth / 2 - this.font.width((FormattedText)text) / 2, 18, -1);
        text = Component.literal((String)"Draw").withStyle(Charta.MINERCRAFTORY);
        guiGraphics.drawString(this.font, (Component)text, this.imageWidth / 4 - 1 - this.font.width((FormattedText)text) / 2, 92, -1);
        text = Component.literal((String)"Play").withStyle(Charta.MINERCRAFTORY);
        guiGraphics.drawString(this.font, (Component)text, 3 * this.imageWidth / 4 + 1 - this.font.width((FormattedText)text) / 2, 92, -1);
        FunGame game = (FunGame)((FunMenu)this.menu).getGame();
        int index = game.getPlayers().indexOf(((FunMenu)this.menu).getCurrentPlayer());
        if (((FunMenu)this.menu).isReversed()) {
            if (--index < 0) {
                index = game.getPlayers().size() - 1;
            }
        } else if (++index > game.getPlayers().size() - 1) {
            index = 0;
        }
        CardPlayer nextPlayer = game.getPlayers().get(index);
        int color = nextPlayer.getColor().getTextureDiffuseColor();
        text = Component.translatable((String)"message.charta.next_player", (Object[])new Object[]{nextPlayer.getName()}).withStyle(s -> s.withColor(nextPlayer.getColor().getTextureDiffuseColor()));
        guiGraphics.drawString(this.font, (Component)text, this.imageWidth / 2 - this.font.width((FormattedText)text) / 2, 132, -1);
        Vec3 c = Vec3.fromRGB24((int)color);
        RenderSystem.setShaderColor((float)((float)c.x), (float)((float)c.y), (float)((float)c.z), (float)1.0f);
        guiGraphics.blit(WIDGETS, this.imageWidth / 2 - 11, 120, 38, ((FunMenu)this.menu).isReversed() ? 12 : 0, 21, 12);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Suit suit = ((FunMenu)this.menu).getCurrentSuit();
        if (suit != null) {
            text = Component.translatable((String)"charta.color");
            guiGraphics.drawString(this.font, (Component)text, this.imageWidth / 2 - this.font.width((FormattedText)text) / 2, 40, -1);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)this.imageWidth / 2.0f - 10.0f, 50.0f, 0.0f);
            guiGraphics.pose().translate(0.5f, 0.0f, 0.0f);
            guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
            ChartaGuiGraphics.blitSuitAndGlow(guiGraphics, this.getDeck(), suit, 0.0f, 0.0f, 0.0f, 0.0f, 13.0f, 13.0f, 13.0f, 13.0f);
            guiGraphics.pose().popPose();
        }
        CardPlayer player = ((FunMenu)this.menu).getCurrentPlayer();
        if (((FunMenu)this.menu).isGameReady()) {
            text = ((FunMenu)this.menu).isCurrentPlayer() ? Component.translatable((String)"message.charta.your_turn").withStyle(s -> s.withColor(player.getColor().getTextureDiffuseColor())) : Component.translatable((String)"message.charta.other_turn", (Object[])new Object[]{player.getName()}).withStyle(s -> s.withColor(player.getColor().getTextureDiffuseColor()));
            guiGraphics.drawString(this.font, (Component)text, this.imageWidth / 2 - this.font.width((FormattedText)text) / 2, 110, -1);
        } else {
            text = Component.translatable((String)"message.charta.dealing_cards").withStyle(ChatFormatting.GOLD);
            guiGraphics.drawString(this.font, (Component)text, this.imageWidth / 2 - this.font.width((FormattedText)text) / 2, 110, -1);
        }
    }

    public void displayItemActivation(ItemStack stack) {
        this.itemActivationItem = stack;
        this.itemActivationTicks = 40;
        this.itemActivationOffX = this.random.nextFloat() * 2.0f - 1.0f;
        this.itemActivationOffY = this.random.nextFloat() * 2.0f - 1.0f;
    }

    public void renderItemActivationAnimation(GuiGraphics guiGraphics, float partialTick) {
        if (this.minecraft != null && this.itemActivationItem != null && this.itemActivationTicks > 0) {
            int i = 40 - this.itemActivationTicks;
            float f = ((float)i + partialTick) / 40.0f;
            float f1 = f * f;
            float f2 = f * f1;
            float f3 = 10.25f * f2 * f1 - 24.95f * f1 * f1 + 25.5f * f2 - 13.8f * f1 + 4.0f * f;
            float f4 = f3 * (float)Math.PI;
            float f5 = this.itemActivationOffX * (float)(guiGraphics.guiWidth() / 4);
            float f6 = this.itemActivationOffY * (float)(guiGraphics.guiHeight() / 4);
            PoseStack posestack = new PoseStack();
            posestack.pushPose();
            posestack.translate((float)(guiGraphics.guiWidth() / 2) + f5 * Mth.abs((float)Mth.sin((float)(f4 * 2.0f))), (float)(guiGraphics.guiHeight() / 2) + f6 * Mth.abs((float)Mth.sin((float)(f4 * 2.0f))), 500.0f);
            float f7 = 50.0f + 175.0f * Mth.sin((float)f4);
            posestack.scale(f7, -f7, f7);
            posestack.mulPose(Axis.YP.rotationDegrees(900.0f * Mth.abs((float)Mth.sin((float)f4))));
            posestack.mulPose(Axis.XP.rotationDegrees(6.0f * Mth.cos((float)(f * 8.0f))));
            posestack.mulPose(Axis.ZP.rotationDegrees(6.0f * Mth.cos((float)(f * 8.0f))));
            guiGraphics.drawManaged(() -> this.minecraft.getItemRenderer().renderStatic(this.itemActivationItem, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, posestack, (MultiBufferSource)guiGraphics.bufferSource(), (Level)this.minecraft.level, 0));
            posestack.popPose();
        }
    }
}

