/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game.fun;

import dev.lucaargolo.charta.game.CardGames;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.game.Suit;
import dev.lucaargolo.charta.game.fun.FunGame;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.menu.CardSlot;
import dev.lucaargolo.charta.menu.HandSlot;
import dev.lucaargolo.charta.menu.ModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FunMenu
extends AbstractCardMenu<FunGame> {
    private int canDoLast = 0;
    private int didntSayLast = 0;
    private final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> {
                    if (((FunGame)FunMenu.this.game).canDoLast()) {
                        yield 1;
                    }
                    yield FunMenu.this.canDoLast;
                }
                case 1 -> {
                    if (((FunGame)FunMenu.this.game).didntSayLast(FunMenu.this.cardPlayer)) {
                        yield 1;
                    }
                    yield FunMenu.this.didntSayLast;
                }
                case 2 -> {
                    if (((FunGame)((FunMenu)FunMenu.this).game).currentSuit != null) {
                        yield ((FunGame)((FunMenu)FunMenu.this).game).currentSuit.id();
                    }
                    yield -1;
                }
                case 3 -> {
                    if (((FunGame)((FunMenu)FunMenu.this).game).reversed) {
                        yield 1;
                    }
                    yield 0;
                }
                case 4 -> ((FunGame)((FunMenu)FunMenu.this).game).drawStack;
                case 5 -> {
                    if (((FunGame)((FunMenu)FunMenu.this).game).canDraw) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    FunMenu.this.canDoLast = value;
                    break;
                }
                case 1: {
                    FunMenu.this.didntSayLast = value;
                    break;
                }
                case 2: {
                    ((FunGame)((FunMenu)FunMenu.this).game).currentSuit = value >= 0 ? Suit.getSuit(value) : null;
                    break;
                }
                case 3: {
                    ((FunGame)((FunMenu)FunMenu.this).game).reversed = value > 0;
                    break;
                }
                case 4: {
                    ((FunGame)((FunMenu)FunMenu.this).game).drawStack = value;
                    break;
                }
                case 5: {
                    ((FunGame)((FunMenu)FunMenu.this).game).canDraw = value > 0;
                }
            }
        }

        public int getCount() {
            return 6;
        }
    };

    public FunMenu(int containerId, Inventory inventory, RegistryFriendlyByteBuf buf) {
        this(containerId, inventory, ContainerLevelAccess.create((Level)inventory.player.level(), (BlockPos)buf.readBlockPos()), (Deck)Deck.STREAM_CODEC.decode((Object)buf), buf.readVarIntArray(), buf.readByteArray());
    }

    public FunMenu(int containerId, Inventory inventory, ContainerLevelAccess access, Deck deck, int[] players, byte[] options) {
        super((MenuType)ModMenus.FUN.get(), containerId, inventory, access, deck, players, options);
        this.addTopPreview(players);
        this.addCardSlot(new CardSlot<FunGame>((FunGame)this.game, g -> g.getSlot(0), 16.0f, 30.0f));
        this.addCardSlot(new CardSlot<FunGame>((FunGame)this.game, g -> g.getSlot(1), 87.0f, 30.0f));
        this.addCardSlot(new HandSlot<FunGame>((FunGame)this.game, g -> !g.isChoosingWild, this.getCardPlayer(), 70.0f - CardSlot.getWidth(CardSlot.Type.HORIZONTAL) / 2.0f, -5.0f, CardSlot.Type.HORIZONTAL));
        this.addDataSlots(this.data);
    }

    public boolean canDoLast() {
        return this.canDoLast > 0;
    }

    public boolean didntSayLast() {
        return this.didntSayLast > 0;
    }

    public Suit getCurrentSuit() {
        return this.data.get(2) >= 0 ? Suit.getSuit(this.data.get(2)) : null;
    }

    public boolean isReversed() {
        return this.data.get(3) > 0;
    }

    public int getDrawStack() {
        return this.data.get(4);
    }

    public boolean canDraw() {
        return this.data.get(5) > 0;
    }

    @Override
    public CardGames.Factory<FunGame> getGameFactory() {
        return CardGames.FUN;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@NotNull Player player) {
        return this.game != null && this.cardPlayer != null && !((FunGame)this.game).isGameOver();
    }
}

