/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game.fun;

import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardPlay;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.game.DrawSlot;
import dev.lucaargolo.charta.game.GameOption;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.game.PlaySlot;
import dev.lucaargolo.charta.game.Rank;
import dev.lucaargolo.charta.game.Suit;
import dev.lucaargolo.charta.game.fun.FunMenu;
import dev.lucaargolo.charta.item.DeckItem;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.network.LastFunPayload;
import dev.lucaargolo.charta.sound.ModSounds;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class FunGame
extends CardGame<FunGame> {
    public static final Set<Suit> SUITS = Set.of(Suit.RED, Suit.YELLOW, Suit.GREEN, Suit.BLUE);
    public static final Set<Rank> RANKS = Set.of(Rank.ONE, Rank.TWO, Rank.THREE, Rank.FOUR, Rank.FIVE, Rank.SIX, Rank.SEVEN, Rank.EIGHT, Rank.NINE, Rank.ZERO, Rank.BLOCK, Rank.REVERSE, Rank.PLUS_2, Rank.WILD, Rank.WILD_PLUS_4);
    public static final int LAST_COOLDOWN = 30;
    private final GameOption.Number LAST_DRAW_AMOUNT = new GameOption.Number(2, 0, 6, (Component)Component.translatable((String)"rule.charta.last_draw_amount"), (Component)Component.translatable((String)"rule.charta.last_draw_amount.description"));
    private final GameOption.Bool STACK_ANY_PLUS2_ON_PLUS2 = new GameOption.Bool(true, (Component)Component.translatable((String)"rule.charta.stack_any_plus2_on_plus2"), (Component)Component.translatable((String)"rule.charta.stack_any_plus2_on_plus2.description"));
    private final GameOption.Bool STACK_SAME_PLUS2_ON_PLUS2 = new GameOption.Bool(true, (Component)Component.translatable((String)"rule.charta.stack_same_plus2_on_plus2"), (Component)Component.translatable((String)"rule.charta.stack_same_plus2_on_plus2.description"));
    private final GameOption.Bool STACK_PLUS4_ON_PLUS2 = new GameOption.Bool(true, (Component)Component.translatable((String)"rule.charta.stack_plus4_on_plus2"), (Component)Component.translatable((String)"rule.charta.stack_plus4_on_plus2.description"));
    private final GameOption.Bool STACK_PLUS4_ON_PLUS4 = new GameOption.Bool(false, (Component)Component.translatable((String)"rule.charta.stack_plus4_on_plus4"), (Component)Component.translatable((String)"rule.charta.stack_plus4_on_plus4.description"));
    private final GameOption.Bool STACK_SAME_PLUS2_ON_PLUS4 = new GameOption.Bool(false, (Component)Component.translatable((String)"rule.charta.stack_same_plus2_on_plus4"), (Component)Component.translatable((String)"rule.charta.stack_same_plus2_on_plus4.description"));
    private final GameOption.Bool STACK_ANY_PLUS2_ON_PLUS4 = new GameOption.Bool(false, (Component)Component.translatable((String)"rule.charta.stack_any_plus2_on_plus4"), (Component)Component.translatable((String)"rule.charta.stack_any_plus2_on_plus4.description"));
    private final PlaySlot playPile;
    private final DrawSlot drawPile;
    public final GameSlot suits = new GameSlot(this){

        @Override
        public boolean removeAll() {
            return false;
        }
    };
    public boolean isChoosingWild;
    public Suit currentSuit;
    private final boolean[] saidLast;
    private final int[] lastCooldown;
    public boolean canDraw = true;
    public int drawStack = 0;
    public boolean startedDraw = false;
    public boolean reversed = false;
    private final Random random = new Random();

    public FunGame(List<CardPlayer> players, Deck deck) {
        super(players, deck);
        this.saidLast = new boolean[players.size()];
        this.lastCooldown = new int[players.size()];
        for (int i = 0; i < players.size(); ++i) {
            this.saidLast[i] = false;
            this.lastCooldown[i] = 0;
        }
        this.drawPile = this.addSlot(new DrawSlot(this, new LinkedList<Card>(), 47.5f, 62.5f, 0.0f, 0.0f, () -> this.canDraw));
        this.playPile = this.addSlot(new PlaySlot(this, new LinkedList<Card>(), 87.5f, 62.5f, 0.0f, 0.0f, this.drawPile));
    }

    @Override
    public GameSlot getPlayerHand(CardPlayer player) {
        return player == this.getCurrentPlayer() && this.isChoosingWild ? this.suits : super.getPlayerHand(player);
    }

    @Override
    protected GameSlot createPlayerHand(CardPlayer player) {
        return new GameSlot(player.hand()){

            @Override
            public void onInsert(CardPlayer player, List<Card> cards, int index) {
                super.onInsert(player, cards, index);
                if (FunGame.this.drawPile.isDraw()) {
                    player.play(null);
                    FunGame.this.drawPile.setDraw(false);
                }
            }

            @Override
            public boolean removeAll() {
                return false;
            }
        };
    }

    @Override
    public List<GameOption<?>> getOptions() {
        return List.of(this.LAST_DRAW_AMOUNT, this.STACK_ANY_PLUS2_ON_PLUS2, this.STACK_SAME_PLUS2_ON_PLUS2, this.STACK_PLUS4_ON_PLUS2, this.STACK_PLUS4_ON_PLUS4, this.STACK_SAME_PLUS2_ON_PLUS4, this.STACK_ANY_PLUS2_ON_PLUS4);
    }

    @Override
    public AbstractCardMenu<FunGame> createMenu(int containerId, Inventory playerInventory, ServerLevel level, BlockPos pos, Deck deck) {
        return new FunMenu(containerId, playerInventory, ContainerLevelAccess.create((Level)level, (BlockPos)pos), deck, this.players.stream().mapToInt(CardPlayer::getId).toArray(), this.getRawOptions());
    }

    @Override
    public Predicate<Deck> getDeckPredicate() {
        return deck -> deck.getCards().size() >= 108 && SUITS.containsAll((Collection<?>)deck.getUniqueSuits()) && deck.getUniqueSuits().containsAll(SUITS);
    }

    @Override
    public Predicate<Card> getCardPredicate() {
        return card -> SUITS.contains(card.suit()) && RANKS.contains(card.rank());
    }

    @Override
    public void startGame() {
        this.drawPile.clear();
        this.playPile.clear();
        this.drawPile.addAll(this.gameDeck);
        this.drawPile.shuffle();
        for (Object player : this.players) {
            player.resetPlay();
            this.getPlayerHand((CardPlayer)player).clear();
            this.getCensoredHand((CardPlayer)player).clear();
        }
        for (int i = 0; i < 7; ++i) {
            for (CardPlayer player : this.players) {
                this.scheduledActions.add(() -> {
                    player.playSound((SoundEvent)ModSounds.CARD_DRAW.get());
                    this.dealCards(this.drawPile, player, 1);
                });
                this.scheduledActions.add(() -> {});
            }
        }
        Card last = this.drawPile.removeLast();
        while (last != null && (last.rank() == Rank.WILD || last.rank() == Rank.JACK || last.rank() == Rank.QUEEN || last.rank() == Rank.PLUS_2 || last.rank() == Rank.WILD_PLUS_4)) {
            this.drawPile.add(last);
            this.drawPile.shuffle();
            last = this.drawPile.removeLast();
        }
        assert (last != null);
        last.flip();
        Card startingCard = last;
        this.scheduledActions.add(() -> {
            this.playPile.addLast(startingCard);
            this.currentSuit = startingCard.suit();
        });
        this.currentPlayer = this.getNextPlayer();
        this.isChoosingWild = false;
        this.isGameReady = false;
        this.isGameOver = false;
        this.table((Component)Component.translatable((String)"message.charta.game_started"));
        this.table((Component)Component.translatable((String)"message.charta.its_player_turn", (Object[])new Object[]{this.currentPlayer.getColoredName()}));
    }

    private void shufflePiles() {
        Card lastCard = this.playPile.removeLast();
        this.playPile.forEach(Card::flip);
        this.drawPile.addAll(this.playPile);
        this.drawPile.shuffle();
        this.playPile.clear();
        this.playPile.add(lastCard);
        this.table((Component)Component.translatable((String)"message.charta.piles_shuffled"));
    }

    @Override
    public void runGame() {
        if (!this.isGameReady) {
            return;
        }
        if (this.drawPile.isEmpty()) {
            if (this.playPile.size() > 1) {
                this.shufflePiles();
            } else {
                this.endGame();
            }
        }
        this.currentPlayer.afterPlay(play -> {
            this.currentPlayer.resetPlay();
            if (play == null) {
                boolean canPlay = false;
                if (this.currentPlayer.shouldCompute()) {
                    this.dealCards(this.drawPile, this.currentPlayer, 1);
                    this.currentPlayer.playSound((SoundEvent)ModSounds.CARD_DRAW.get());
                }
                this.play(this.currentPlayer, (Component)Component.translatable((String)"message.charta.drew_a_card"));
                if (this.drawStack > 0) {
                    this.startedDraw = true;
                    --this.drawStack;
                    this.canDraw = this.drawStack > 0;
                } else {
                    this.canDraw = false;
                }
                if (!this.startedDraw) {
                    canPlay = this.getBestPlay(this.currentPlayer) != null;
                }
                this.saidLast[this.getPlayers().indexOf((Object)this.currentPlayer)] = false;
                if (!this.canDraw && !canPlay) {
                    this.startedDraw = false;
                    this.nextPlayerAndRunGame();
                } else {
                    this.runGame();
                }
            } else if (!this.currentPlayer.shouldCompute() || this.canPlay(this.currentPlayer, (CardPlay)play)) {
                Card card = play.cards().getLast();
                this.currentPlayer.playSound((SoundEvent)ModSounds.CARD_PLAY.get());
                this.currentSuit = card.suit();
                if (this.isChoosingWild) {
                    this.play(this.currentPlayer, (Component)Component.translatable((String)"message.charta.chose_a_suit", (Object[])new Object[]{Component.translatable((String)this.deck.getSuitTranslatableKey(this.currentSuit)).withColor(this.deck.getSuitColor(this.currentSuit))}));
                    if (!this.currentPlayer.shouldCompute()) {
                        this.playPile.removeLast();
                    }
                    this.isChoosingWild = false;
                } else {
                    this.play(this.currentPlayer, (Component)Component.translatable((String)"message.charta.played_a_card", (Object[])new Object[]{Component.translatable((String)this.deck.getCardTranslatableKey(card)).withColor(this.deck.getCardColor(card))}));
                }
                if (this.currentPlayer.shouldCompute() && this.getPlayerHand(this.currentPlayer).remove(card)) {
                    this.getCensoredHand(this.currentPlayer).removeLast();
                    this.playPile.addLast(card);
                }
                if (this.getFullHand(this.currentPlayer).findAny().isEmpty()) {
                    this.endGame();
                } else if (card.rank() == Rank.WILD || card.rank() == Rank.WILD_PLUS_4) {
                    if (card.rank() == Rank.WILD_PLUS_4) {
                        this.drawStack += 4;
                    }
                    if (this.currentPlayer.shouldCompute()) {
                        this.currentSuit = this.getMostFrequentSuit(this.currentPlayer);
                        this.play(this.currentPlayer, (Component)Component.translatable((String)"message.charta.chose_a_suit", (Object[])new Object[]{Component.translatable((String)this.deck.getSuitTranslatableKey(this.currentSuit))}));
                        this.nextPlayerAndRunGame();
                    } else {
                        this.isChoosingWild = true;
                        this.suits.clear();
                        this.suits.addAll(this.gameSuits.stream().map(s -> new Card((Suit)s, Rank.ZERO)).toList());
                        this.canDraw = false;
                        this.runGame();
                    }
                } else {
                    if (card.rank() == Rank.BLOCK) {
                        this.currentPlayer = this.getNextPlayer();
                        this.table((Component)Component.translatable((String)"message.charta.player_was_skipped", (Object[])new Object[]{this.currentPlayer.getColoredName()}));
                    } else if (card.rank() == Rank.REVERSE) {
                        boolean bl = this.reversed = !this.reversed;
                        if (this.players.size() == 2) {
                            this.currentPlayer = this.getNextPlayer();
                        }
                        this.table((Component)Component.translatable((String)"message.charta.game_reversed"));
                    } else if (card.rank() == Rank.PLUS_2) {
                        this.drawStack += 2;
                    }
                    this.nextPlayerAndRunGame();
                }
            }
        });
    }

    private void nextPlayerAndRunGame() {
        this.canDraw = true;
        this.currentPlayer = this.getNextPlayer();
        if (this.drawStack > 0) {
            this.table((Component)Component.translatable((String)"message.charta.its_player_turn_draw_stack", (Object[])new Object[]{this.currentPlayer.getColoredName(), this.drawStack}));
        } else {
            this.table((Component)Component.translatable((String)"message.charta.its_player_turn", (Object[])new Object[]{this.currentPlayer.getColoredName()}));
        }
        this.runGame();
    }

    @Override
    public void endGame() {
        if (this.getFullHand(this.currentPlayer).findAny().isEmpty()) {
            this.currentPlayer.sendTitle((Component)Component.translatable((String)"message.charta.you_won").withStyle(ChatFormatting.GREEN), (Component)Component.translatable((String)"message.charta.congratulations"));
            this.getPlayers().stream().filter(player -> player != this.currentPlayer).forEach(player -> player.sendTitle((Component)Component.translatable((String)"message.charta.you_lost").withStyle(ChatFormatting.RED), (Component)Component.translatable((String)"message.charta.won_the_match", (Object[])new Object[]{this.currentPlayer.getName()})));
        } else {
            this.getPlayers().forEach(player -> {
                player.sendTitle((Component)Component.translatable((String)"message.charta.draw").withStyle(ChatFormatting.YELLOW), (Component)Component.translatable((String)"message.charta.no_winner"));
                player.sendMessage((Component)Component.translatable((String)"message.charta.match_unable").withStyle(ChatFormatting.GOLD));
            });
        }
        this.isGameOver = true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isGameReady) {
            for (int i = 0; i < this.getPlayers().size(); ++i) {
                CardPlayer player = this.getPlayers().get(i);
                boolean didntSayLast = this.didntSayLast(player);
                if (player.shouldCompute()) {
                    if (didntSayLast && this.lastCooldown[i] % 15 == 0 && this.random.nextBoolean()) {
                        this.sayLast(player);
                    }
                    for (int j = 0; j < this.getPlayers().size(); ++j) {
                        CardPlayer other = this.getPlayers().get(j);
                        if (this.lastCooldown[j] <= 30 || !this.random.nextBoolean() || !this.didntSayLast(other)) continue;
                        this.sayLast(player);
                    }
                }
                if (!didntSayLast) continue;
                int n = i;
                this.lastCooldown[n] = this.lastCooldown[n] + 1;
            }
        }
    }

    @Override
    public boolean canPlay(CardPlayer player, CardPlay play) {
        List<Card> cards = play.cards();
        if (cards.size() != 1) {
            return false;
        }
        Card card = cards.getLast();
        Card lastCard = this.playPile.getLast();
        if (!this.isGameReady || lastCard == null) {
            return false;
        }
        if (this.isChoosingWild) {
            return true;
        }
        if (this.drawStack > 0) {
            boolean isPlus4;
            if (this.startedDraw) {
                return false;
            }
            boolean bl = isPlus4 = lastCard.rank() == Rank.WILD_PLUS_4;
            if (isPlus4) {
                return (Boolean)this.STACK_PLUS4_ON_PLUS4.get() != false && card.rank() == Rank.WILD_PLUS_4 || (Boolean)this.STACK_ANY_PLUS2_ON_PLUS4.get() != false && card.rank() == Rank.PLUS_2 || (Boolean)this.STACK_SAME_PLUS2_ON_PLUS4.get() != false && card.rank() == Rank.PLUS_2 && card.suit() == this.currentSuit;
            }
            return (Boolean)this.STACK_PLUS4_ON_PLUS2.get() != false && card.rank() == Rank.WILD_PLUS_4 || (Boolean)this.STACK_ANY_PLUS2_ON_PLUS2.get() != false && card.rank() == Rank.PLUS_2 || (Boolean)this.STACK_SAME_PLUS2_ON_PLUS2.get() != false && card.rank() == Rank.PLUS_2 && card.suit() == this.currentSuit;
        }
        return card.rank() == Rank.WILD || card.rank() == Rank.WILD_PLUS_4 || card.rank() == lastCard.rank() || card.suit() == this.currentSuit;
    }

    public void sayLast(CardPlayer current) {
        for (int i = 0; i < this.players.size(); ++i) {
            CardPlayer player = (CardPlayer)this.players.get(i);
            if (!this.didntSayLast(player)) continue;
            this.table((Component)Component.translatable((String)"message.charta.player_said_last", (Object[])new Object[]{current.getColoredName()}));
            if (player == current) {
                player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value());
                this.saidLast[i] = true;
                this.lastCooldown[i] = 0;
                continue;
            }
            if (this.lastCooldown[i] <= 30) continue;
            int drawAmount = (Integer)this.LAST_DRAW_AMOUNT.get();
            if (this.drawPile.size() < drawAmount) {
                this.shufflePiles();
            }
            if (this.drawPile.size() >= drawAmount) {
                this.players.forEach(p -> {
                    LivingEntity entity = p.getEntity();
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new LastFunPayload(DeckItem.getDeck(this.deck)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                });
                this.table((Component)Component.translatable((String)"message.charta.player_automatically_drew_cards", (Object[])new Object[]{player.getColoredName(), drawAmount}));
                this.dealCards(this.drawPile, player, drawAmount);
            } else {
                this.endGame();
            }
            this.saidLast[i] = true;
            this.lastCooldown[i] = 0;
        }
    }

    public boolean canDoLast() {
        return this.isGameReady && this.getPlayers().stream().anyMatch(this::didntSayLast);
    }

    public boolean didntSayLast(CardPlayer player) {
        int index = this.getPlayers().indexOf(player);
        if (this.saidLast[index]) {
            return false;
        }
        int size = (int)this.getFullHand(player).count();
        return size == 1;
    }

    private CardPlayer getNextPlayer() {
        if (this.currentPlayer == null) {
            return this.getPlayers().getFirst();
        }
        int indexOf = this.getPlayers().indexOf(this.currentPlayer);
        if (this.reversed) {
            if (indexOf - 1 >= 0) {
                return this.getPlayers().get(indexOf - 1);
            }
            return this.getPlayers().getLast();
        }
        return this.getPlayers().get((indexOf + 1) % this.players.size());
    }
}

