/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game.crazyeights;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.gui.screens.GameScreen;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.Suit;
import dev.lucaargolo.charta.game.crazyeights.CrazyEightsGame;
import dev.lucaargolo.charta.game.crazyeights.CrazyEightsMenu;
import dev.lucaargolo.charta.utils.ChartaGuiGraphics;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;

public class CrazyEightsScreen
extends GameScreen<CrazyEightsGame, CrazyEightsMenu> {
    private static final ResourceLocation TEXTURE = Charta.id("textures/gui/crazy_eights.png");

    public CrazyEightsScreen(CrazyEightsMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.imageWidth = 140;
        this.imageHeight = 170;
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        MutableComponent text;
        Suit suit = ((CrazyEightsMenu)this.menu).getCurrentSuit();
        if (suit != null) {
            text = Component.translatable((String)"charta.suit");
            guiGraphics.drawString(this.font, (Component)text, this.imageWidth / 2 - this.font.width((FormattedText)text) / 2, 40, -1);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)this.imageWidth / 2.0f - 10.0f, 50.0f, 0.0f);
            guiGraphics.pose().translate(0.5f, 0.0f, 0.0f);
            guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
            ChartaGuiGraphics.blitSuitAndGlow(guiGraphics, this.getDeck(), suit, 0.0f, 0.0f, 0.0f, 0.0f, 13.0f, 13.0f, 13.0f, 13.0f);
            guiGraphics.pose().popPose();
        }
        CardPlayer player = ((CrazyEightsMenu)this.menu).getCurrentPlayer();
        DyeColor color = player.getColor();
        if (((CrazyEightsMenu)this.menu).isGameReady()) {
            text = ((CrazyEightsMenu)this.menu).isCurrentPlayer() ? Component.translatable((String)"message.charta.your_turn").withStyle(s -> s.withColor(color.getTextureDiffuseColor())) : Component.translatable((String)"message.charta.other_turn", (Object[])new Object[]{player.getName()}).withStyle(s -> s.withColor(color.getTextureDiffuseColor()));
            guiGraphics.drawString(this.font, (Component)text, this.imageWidth / 2 - this.font.width((FormattedText)text) / 2, 105, -1);
            text = Component.translatable((String)"message.charta.draws_left", (Object[])new Object[]{((CrazyEightsMenu)this.menu).getDrawsLeft()});
            guiGraphics.drawString(this.font, (Component)text, this.imageWidth / 2 - this.font.width((FormattedText)text) / 2, 115, -1);
        } else {
            text = Component.translatable((String)"message.charta.dealing_cards").withStyle(ChatFormatting.GOLD);
            guiGraphics.drawString(this.font, (Component)text, this.imageWidth / 2 - this.font.width((FormattedText)text) / 2, 110, -1);
        }
    }
}

