/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game.crazyeights;

import dev.lucaargolo.charta.game.CardGames;
import dev.lucaargolo.charta.game.Deck;
import dev.lucaargolo.charta.game.Suit;
import dev.lucaargolo.charta.game.crazyeights.CrazyEightsGame;
import dev.lucaargolo.charta.menu.AbstractCardMenu;
import dev.lucaargolo.charta.menu.CardSlot;
import dev.lucaargolo.charta.menu.HandSlot;
import dev.lucaargolo.charta.menu.ModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CrazyEightsMenu
extends AbstractCardMenu<CrazyEightsGame> {
    private final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> ((CrazyEightsGame)((CrazyEightsMenu)CrazyEightsMenu.this).game).drawsLeft;
                case 1 -> {
                    if (((CrazyEightsGame)((CrazyEightsMenu)CrazyEightsMenu.this).game).currentSuit != null) {
                        yield ((CrazyEightsGame)((CrazyEightsMenu)CrazyEightsMenu.this).game).currentSuit.id();
                    }
                    yield -1;
                }
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    ((CrazyEightsGame)((CrazyEightsMenu)CrazyEightsMenu.this).game).drawsLeft = (byte)value;
                    break;
                }
                case 1: {
                    ((CrazyEightsGame)((CrazyEightsMenu)CrazyEightsMenu.this).game).currentSuit = value >= 0 ? Suit.getSuit(value) : null;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public CrazyEightsMenu(int containerId, Inventory inventory, RegistryFriendlyByteBuf buf) {
        this(containerId, inventory, ContainerLevelAccess.create((Level)inventory.player.level(), (BlockPos)buf.readBlockPos()), (Deck)Deck.STREAM_CODEC.decode((Object)buf), buf.readVarIntArray(), buf.readByteArray());
    }

    public CrazyEightsMenu(int containerId, Inventory inventory, ContainerLevelAccess access, Deck deck, int[] players, byte[] options) {
        super((MenuType)ModMenus.CRAZY_EIGHTS.get(), containerId, inventory, access, deck, players, options);
        this.addTopPreview(players);
        this.addCardSlot(new CardSlot<CrazyEightsGame>((CrazyEightsGame)this.game, g -> g.getSlot(0), 16.0f, 30.0f));
        this.addCardSlot(new CardSlot<CrazyEightsGame>((CrazyEightsGame)this.game, g -> g.getSlot(1), 87.0f, 30.0f));
        this.addCardSlot(new HandSlot<CrazyEightsGame>((CrazyEightsGame)this.game, g -> !g.isChoosingWild, this.getCardPlayer(), 70.0f - CardSlot.getWidth(CardSlot.Type.HORIZONTAL) / 2.0f, -5.0f, CardSlot.Type.HORIZONTAL));
        this.addDataSlots(this.data);
    }

    public int getDrawsLeft() {
        return this.data.get(0);
    }

    public Suit getCurrentSuit() {
        return this.data.get(1) >= 0 ? Suit.getSuit(this.data.get(1)) : null;
    }

    @Override
    public CardGames.Factory<CrazyEightsGame> getGameFactory() {
        return CardGames.CRAZY_EIGHTS;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@NotNull Player player) {
        return this.game != null && this.cardPlayer != null && !((CrazyEightsGame)this.game).isGameOver();
    }
}

